#include <allegro.h>
#include "dime.h"
#include "tile.h"


BITMAP * buffer;
extern BITMAP ** tiles;


void loop();
void draw_mouse();
void check_keys();
void check_mouse();
void draw_select();
void edit_tile(int,int);
void save(char * filename);
void load(char * filename);


s_map map;	//the map;

bool quit;  //if false quit the editor
int x,y;   //top left coordinates for the map
int sx,sy; //start tile
int type;  //the type you are currently adding
bool tdown; //for switching types;

void main()
{
	allegro_init();
    set_color_depth(16);
    set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
    buffer = create_bitmap(640,480);
    clear(buffer);
    install_keyboard();
    install_mouse();
    dime_init();
    clear_keybuf();
    if(dialogf("Enter size for new map. esc to open map",ALIGN_CENTRE,ALIGN_CENTRE,320,
                           "Width%int[1,]"
                           "Height%int[1,]",
                           &map.w,
                           &map.h
             )!=1)
             {
            	char * temp = new char[100];
         		clear_keybuf();
   				if (dialogf("Open Map",ALIGN_CENTRE,ALIGN_CENTRE,320,
                           "FileName%filename[100,mkh,Open]"
                           ,temp)==1)
     			{
     				load(temp);
     			}
                else
                {
                	exit(0);
                }
     			delete[] temp;
             }
             else
             {
             	create_tiles(&map);
             	reset_tiles(&map);
             }

    load_tiles();
    x=0;
    y=0;
    type=1;
    quit=true;
    tdown=false;
    loop();
}


void flip()
{
	blit(buffer,screen,0,0,0,0,640,480);
}

void loop()
{
	while(quit)
    {
        check_keys();
    	check_mouse();
        clear(buffer);
        draw_grid(buffer,&map,x,y);
        draw_map(buffer,&map,x,y);
        draw_mouse();
        draw_select();
        flip();
    }

}


void check_mouse()
{
	if (mouse_x<=2)
        x++;
    if (mouse_x>=638)
        x--;
    if (mouse_y<=2)
        y++;
    if (mouse_y>=478)
        y--;
    if (mouse_b&1 || mouse_b&2)
    {
    	int xt = (mouse_x-x)/32; //calculate which tile the mouse in on
        int yt = (mouse_y-y)/32;
        if (mouse_x-x<0 || mouse_y-y<0) xt=-1; //dirty hack
        if (xt>=0 && xt< map.w && yt>=0 && yt < map.h)
        {
        	if (mouse_b&1 && !(key_shifts&KB_CTRL_FLAG) &&!(key_shifts&KB_ALT_FLAG)) map.tiles[yt*map.w+xt].type=type;
        	if (mouse_b&2)	edit_tile(xt,yt); //edit tile
        	if (mouse_b&1 && (key_shifts&KB_CTRL_FLAG)) map.tiles[yt*map.w+xt].type=0;    //rightmouse to clear tile
        	if (mouse_b&1 && (key_shifts&KB_ALT_FLAG))
        	{
    	    	map.enterx=xt;
	        	map.entery=yt;
        	}
        }
      }
}

void draw_mouse()
{
	hline(buffer,mouse_x-5,mouse_y,mouse_x+5,makecol(255,255,255));
    vline(buffer,mouse_x,mouse_y-5,mouse_y+5,makecol(255,255,255));
}

void draw_select()
{
	blit(tiles[type-1],buffer,0,0,600,8,32,32);
	//also use this function to draw enterpoint
    circle(buffer,x+map.enterx*32+16,y+map.entery*32+16,7,makecol(0,0,255));

}

void check_keys()
{
   if (key[KEY_ESC]) quit=false;
   if (!key[KEY_OPENBRACE] && !key[KEY_CLOSEBRACE]) tdown=false;
   if (key[KEY_OPENBRACE] && !tdown)
   {
   		tdown=true;
        if (type>1) type--;
   }
   if (key[KEY_CLOSEBRACE] && !tdown)
   {
   		tdown=true;
        if (type<8) type++;
   }
   if (key[KEY_F1])
   {
   		char * temp = new char[100];
         clear_keybuf();
   		if (dialogf("Open Map",ALIGN_CENTRE,ALIGN_CENTRE,320,
                           "FileName%filename[100,mkh,Open]"
                           ,temp)==1)
     {
     	load(temp);
     }
     delete[] temp;
  }
   if (key[KEY_F2])
   {
   		char * temp = new char[100];
         clear_keybuf();
   		if (dialogf("Save Map",ALIGN_CENTRE,ALIGN_CENTRE,320,
                           "FileName%filename[100,mkh,Save]"
                           ,temp)==1)
     {
     	save(temp);
     }
     delete[] temp;
  }
    

}

void edit_tile(int xt, int yt)
{

    //easy way to remove mouse
    clear(buffer);
    draw_grid(buffer,&map,x,y);
    draw_map(buffer,&map,x,y);
    draw_select();
    flip();

    s_tile * tile = &map.tiles[yt*map.w+xt];
 	int affect,movex,movey,item,open,afdoor,vert;
    affect = tile->affect;
    movex = tile->movex;
	movey = tile->movey;
	item = tile->item;
    open=isset(tile->flags,TILE_OPENED);
    afdoor=isset(tile->flags,TILE_AFDOOR);
    vert=isset(tile->flags,TILE_VERT);
     clear_keybuf();
   
	if (dialogf("Edit Tile",ALIGN_CENTRE,ALIGN_CENTRE,320,
                           "Affect%int[0,]"
                           "Move-x%int[,]"
                           "Move-y%int[,]"
                           "Open%bool[]"
                           "Affects door%bool[]"
                           "Vertical door%bool[]"
                           "Item%int[0,]",
                           &affect,
                           &movex,
                           &movey,
                           &open,
                           &afdoor,
                           &vert,
                           &item)==1)
     {
     	tile->affect=affect;
        tile->movex=movex;
		tile->movey=movey;
		tile->item=item;
        if (open) tile->flags|=TILE_OPENED;
        if (!open) tile->flags&=~TILE_OPENED;
        if (afdoor) tile->flags|=TILE_AFDOOR;
		if (!afdoor) tile->flags&=~TILE_AFDOOR;
        if (vert) tile->flags|=TILE_VERT;
	    if (!vert) tile->flags&=~TILE_VERT;
    }

}


void save(char * filename)
{
	FILE *file = fopen(filename,"w");
    if (!file) return;
    save_map(&map,file);
}


void load(char * filename)
{
	FILE *file = fopen(filename,"r");
    if (!file) return;
    delete [] map.tiles;
    load_map(&map,file);
}







