#include <math.h>
#include <stdio.h>
#include <allegro.h>

#ifndef PI
const double PI = 3.1415926535897932384626433832795;
#endif

#include "obj3d.h"
#include "device.h"

#define GAME_SPEED 60  // game speed in fps
#define STEP       3   // size of steps in texels
#define DEV_COUNT  5   // total types of devices in the game.

volatile int timer;
void game_init();      // setup game

extern BITMAP *buffer;        // back buffer
BITMAP *target;
BITMAP *target1;
BITMAP *target2;
OBJ3D *obj[DEV_COUNT]; // devices
int m=false;
void complete_level()
{
  m=true;
}  
int starthack(int leveln)
{
  
  MATRIX_f camera;
  char filename[80];

  level *lvl = new level;
  char *fname = new char[12];
  sprintf(fname,"level%d.txt",leveln);
  lvl->load(fname);
  delete [] fname;

  float x=0,y=500,z=500;
  float angle=0;
  V3D_f front,top;
  int cc=0;

  timer=0;
  int update=false;
  int F1_down=false;
  int TAB_down=false;
  MATRIX_f rt,rt2;
  int cx,cy;

  text_mode(-1);

  int t=false;
  
  while(!key[KEY_ESC]&&!key[KEY_SPACE]) {  
    while(timer>0) {
      timer--;update=true;
      if(key_shifts & KB_ALT_FLAG) {
        if(key[KEY_LEFT]) {y-=cos(angle*PI/128+PI/2)*STEP;x+=sin(angle*PI/128+PI/2)*STEP;}
        if(key[KEY_RIGHT]) {y+=cos(angle*PI/128+PI/2)*STEP;x-=sin(angle*PI/128+PI/2)*STEP;}
      }
      else {
        if(key[KEY_LEFT]) angle+=0.5;
        if(key[KEY_RIGHT]) angle-=0.5;
      }
      if(key[KEY_UP]) {y-=cos(angle*PI/128)*STEP;x+=sin(angle*PI/128)*STEP;}
      if(key[KEY_DOWN]) {y+=cos(angle*PI/128)*STEP;x-=sin(angle*PI/128)*STEP;}
      if(key[KEY_MINUS]) {y+=cos(angle*PI/128)*STEP;x-=sin(angle*PI/128)*STEP;z+=sin(PI/4)*STEP;}
      if(key[KEY_EQUALS]) {y-=cos(angle*PI/128)*STEP;x+=sin(angle*PI/128)*STEP;z-=sin(PI/4)*STEP;}
      if(key[KEY_F1]) F1_down=true;
      else if(F1_down) {
        F1_down=false;
        int j=0;
        do {
          sprintf(filename,"shot%d.bmp",j++);
        }
        while(exists(filename));
        save_bitmap(filename,buffer,NULL);
          
      }
      if(key[KEY_TAB]) TAB_down=true;
      else if(TAB_down) {
        TAB_down=false;
        cc=(cc+1)%3;

      }
      get_z_rotate_matrix_f(&rt, angle);
      get_x_rotate_matrix_f(&rt2,32);
      matrix_mul_f(&rt2,&rt,&rt);
      apply_matrix_f(&rt, 0, -1, 0, &front.x, &front.y, &front.z);
      apply_matrix_f(&rt, 0, 0, 1, &top.x, &top.y, &top.z);
   
      get_camera_matrix_f(&camera, 
                  x, y, z, 
                  front.x, front.y, front.z, 
                  top.x, top.y, top.z, 
                  32, 1.0);
      cx=int(x+sin(angle*PI/128)*z);
      cy=int(y-cos(angle*PI/128)*z);

      lvl->update();

      if(lvl->check(cx,cy))
        t=true;
      else t=false;
    }
    if(update) {
      update=false;
      clear_zbuffer(0);
      clear(buffer);

      if(t) blit(target2,target,0,0,0,0,target->w,target->h);
      else blit(target1,target,0,0,0,0,target->w,target->h);
      
      lvl->draw(buffer,target,&camera);

      if(m)
        textprintf_centre(target,font,160,230,makecol(255,255,255),"Level complete press [space] to continue");
      else
        textprintf_centre(target,font,160,230,makecol(255,255,255),"Press [space] to leave and reset cyber puzzle.");
  
      masked_stretch_blit(target,buffer,0,0,target->w,target->h,0,0,SCREEN_W,SCREEN_H);

      acquire_screen();
      blit(buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
      release_screen();
    }
    else yield_timeslice();
  }
  
  delete lvl;
  
  if(m) {
    m=false;
  	return 1;
  }

  return 0;  
}

void do_timer()
{
  timer++;
}
END_OF_FUNCTION(do_timer);

DATAFILE *fonts;

void game_close()
{
  if(fonts)
    unload_datafile(fonts);
 
  destroy_zbuffer();

  for (int i=0;i<DEV_COUNT;i++)
    destroy_3d(obj[i]);

  destroy_bitmap(buffer);
}

FONT *old_font;

void cyber_init()
{

  LOCK_VARIABLE(timer);
  LOCK_FUNCTION(do_timer);
  
  install_int_ex(do_timer,BPS_TO_TIMER(GAME_SPEED));
 
  set_trans_blender(0,0,0,128);
  
  set_projection_viewport(0,0,SCREEN_W,SCREEN_H);

  char filename[30];

  target=create_bitmap(320,240);

  target1=load_bitmap("target1.bmp",NULL);

  if(!target1) {
    set_gfx_mode(GFX_TEXT,0,0,0,0);     // print a friendly message and quit
    allegro_message("hehe.. hehe.. You're like stupid.. hehe.. What did you to target1.bmp?");
    exit(1);
  }
  
  target2=load_bitmap("target2.bmp",NULL);
  if(!target2) {
    set_gfx_mode(GFX_TEXT,0,0,0,0);     // print a friendly message and quit
    allegro_message("hehe.. hehe.. You're like stupid.. hehe.. What did you to target2.bmp?");
    exit(1);
  }
  if(!exists("line.ase")) {             // if we can't find a file
    set_gfx_mode(GFX_TEXT,0,0,0,0);     // print a friendly message and quit
    allegro_message("Oi! You! NO! You are not to muck about with the 3d files! I can't find %s and it's your fault!!",filename);
    exit(1);
  }

  for(int i=0;i<DEV_COUNT;i++) {
    sprintf(filename,"device%d.ase",i+1);
    if(!exists(filename)) {               // if we can't find a file
      set_gfx_mode(GFX_TEXT,0,0,0,0);     // print a friendly message and quit
      allegro_message("Oi! You! NO! You are not to muck about with the 3d files! I can't find %s and it's your fault!!",filename);
      exit(1);
    }
    obj[i]=load_3d(filename);
  
  }

  if(exists("font.dat")) {
    fonts=load_datafile("font.dat");
  }
  else fonts=NULL;
  old_font=font;
  if(fonts) font=(FONT *)fonts[0].dat;

  create_zbuffer(buffer);

  atexit(game_close);
}


