//
//  This file handles drawing 3d objects to the screen
//  and deleting them from memory.
//
//

#include <math.h>

#include <allegro.h>

#include "obj3d.h"


void draw_3d(BITMAP *bmp,OBJ3D *o,MATRIX_f *camera,int x,int y,int color) 
{
  float col;
  int poly_type = o->poly_type | POLYTYPE_ZBUF;
  
  int i,j;
  int r,g,b;
  V3D_f *v=o->v;
  V3D_f *vt=o->tmp;
  V3D_f *n=o->vnormal;

  POLY3D *p=o->p;

  MATRIX_f tmp;
  MATRIX_f ntmp;
  MATRIX_f ttmp;

  static V3D_f *vout[6],*vtmp[6],_vout[6],_vtmp[6];
  V3D_f light;
  light.x=1.0;
  light.y=-1.0;
  light.z=1.0;
 
  int itmp[6];
  int vc;

  for (int i=0; i<6; i++) {
    vout[i]=&_vout[i];
    vtmp[i]=&_vtmp[i];
  }

  get_translation_matrix_f(&ttmp,x,y,0);
  matrix_mul_f(&o->pos,&ttmp,&ttmp);
  matrix_mul_f(&ttmp,camera,&tmp);
  matrix_mul_f(&ttmp,camera,&ntmp);
  ntmp.t[0]=0;
  ntmp.t[1]=0;
  ntmp.t[2]=0;

  V3D_f m;

//  apply_matrix_f(&ntmp,light.x, light.y, light.z,
//                        &light.x, &light.y, &light.z);

  for(i=0;i<o->num_vertex;i++,v++,vt++,n++)
  {
    apply_matrix_f(&tmp,v->x, v->y, v->z,
                        &vt->x, &vt->y, &vt->z);
    apply_matrix_f(&ntmp,n->x, n->y, n->z,
                        &m.x, &m.y, &m.z);

    if(poly_type&POLYTYPE_GRGB) {
      col=MID(0.3,(dot_product_f(m.x,m.y,m.z,light.x,light.y,light.z)+2)/3,1);
      r=int(col*getr(color));
      g=int(col*getg(color));
      b=int(col*getb(color));
      vt->c=r<<16|g<<8|b;
    }
  }

  
  for(i=0;i<o->num_poly;i++,p++) {
    apply_matrix_f(&ntmp,p->normal.x, p->normal.y, p->normal.z,
                        &m.x, &m.y, &m.z);
    
    if(m.z>0)  // we can't see it!
      continue;
//    if(polygon_z_normal_f(p->v[0],p->v[1],p->v[2])>0)
//      continue;
    
    vc=clip3d_f(poly_type, 0.01, -1, 3, 
                (AL_CONST V3D_f **)p->v, 
                vout, vtmp, itmp);

    for(j=0;j<vc;j++) {
      persp_project_f(vout[j]->x, vout[j]->y, vout[j]->z, &vout[j]->x, &vout[j]->y);
    }

    polygon3d_f(bmp, poly_type, o->tex, vc, vout);
    
  }

}


void destroy_3d(OBJ3D *o) 
{
  if(o) {
    if(o->v)
      delete []o->v;
    if(o->p) 
      delete []o->p;
    if(o->name)
      delete []o->name;
    if(o->tmp)
      delete []o->tmp;
    if(o->vnormal)
      delete []o->vnormal;
    delete o;
  }
} 


  
