#include "MinesFlowersScoreTable.h"
#include "DataOutputStream.h"
#include "DataInputStream.h"

void MinesFlowersScoreTable::load() {
	try {
		DataInputStream dis(HOF_FILE);
		for(int i=0; i<10; i++) {
			for(int j=0; j<2; j++) {
				for(int k=0; k<2; k++) {
					mfs[i][j][k].load(dis);
				}
			}
		}
	}
	catch (StreamException ) {
	}
}

void MinesFlowersScoreTable::save() {
	try {
		DataOutputStream dos(HOF_FILE);
		for(int i=0; i<10; i++) {
			for(int j=0; j<2; j++) {
				for(int k=0; k<2; k++) {
					mfs[i][j][k].save(dos);
				}
			}
		}
	}
	catch (StreamException ) {
	}
}

bool MinesFlowersScoreTable::insert(int size, bool random, bool circular, int score, char* name) {
	return get(size, random, circular).insert(score, name);
}

MinesFlowersScore& MinesFlowersScoreTable::get(int size, bool random, bool circular) {
	return mfs[size - 3][random? 1 : 0][circular? 1 : 0];
}


