#include "MinesFlowersScore.h"
#include <string.h>

MinesFlowersScore::MinesFlowersScore() {
	for (int i=0; i<NUM_HISCORES; i++) {
		scores[i] = 11000 + i * 1000;
		strcpy(names[i], i%2? "Mister Mine" : "Mister Flower");
	}
}
	
bool MinesFlowersScore::insert(int score, char* name) {
	for (int i=0; i<NUM_HISCORES; i++) {
		if (score < scores[i]) {
			for (int j=NUM_HISCORES - 1; j>i; j--) {
				scores[j] = scores[j - 1];
				strcpy(names[j], names[j - 1]);
			}
			scores[i] = score;
			strcpy(names[i], name);
			return true;
		}
	}
	return false;
}

int MinesFlowersScore::get_entries() {
	return NUM_HISCORES;
}

int MinesFlowersScore::get_score(int pos) {
	return scores[pos];
}

char* MinesFlowersScore::get_name(int pos) {
	return names[pos];
}

void MinesFlowersScore::load(DataInputStream& dis) {
	for (int i=0; i<NUM_HISCORES; i++) {
		dis.readString(names[i]);
		scores[i] = dis.readInt();
	}
}

void MinesFlowersScore::save(DataOutputStream& dos) {
	for (int i=0; i<NUM_HISCORES; i++) {
		dos.writeString(names[i]);
		dos.writeInt(scores[i]);
	}
}

