#include "MinesFlowersOptions.h"
#include "DataOutputStream.h"
#include "DataInputStream.h"

MinesFlowersOptions::MinesFlowersOptions() : 
	circular(false), random(false), size(4), music(true), sound(true) {
}

void MinesFlowersOptions::load() {
	try {
		DataInputStream dis(CFG_FILE);
		circular = dis.readBool();
		random = dis.readBool();
		size = dis.readInt();
		music = dis.readBool();
		sound = dis.readBool();
	}
	catch (StreamException ) {
	}
}

void MinesFlowersOptions::save() {
	try {
		DataOutputStream dos(CFG_FILE);
		dos.writeBool(circular);
		dos.writeBool(random);
		dos.writeInt(size);
		dos.writeBool(music);
		dos.writeBool(sound);
	}
	catch (StreamException ) {
	}
}
