#include <allegro.h>
#include "../SourceData.h"

void initialize();
void finalize();

int main(int argc, char *argv[]) {
	initialize();
	PALETTE pal;
	BITMAP *arrow = load_bitmap("mouse_arrow.bmp", pal);
	BITMAP *logo = load_bitmap("logo.bmp", pal);
	BITMAP *mine = load_bitmap("mines_icon.bmp", pal);
	BITMAP *flow = load_bitmap("flower_icon.bmp", pal);
	BITMAP *texture = load_bitmap("texture.bmp", pal);
	BITMAP *start = load_bitmap("start.bmp", pal);
	BITMAP *options = load_bitmap("options.bmp", pal);
	BITMAP *hall = load_bitmap("hall.bmp", pal);
	BITMAP *help = load_bitmap("help.bmp", pal);
	BITMAP *quit = load_bitmap("exit.bmp", pal);
	BITMAP *footer = load_bitmap("footer.bmp", pal);
	MIDI *zombie = load_midi("zombie.mid");
	SAMPLE *fx1 = load_sample("fx0016.wav");
	SAMPLE *fx2 = load_sample("fx0009.wav");
	SAMPLE *fx3 = load_sample("applause3.wav");
	set_palette(pal);
	midi_to_source(zombie, "zombie");
	sample_to_source(fx1, "fx1");
	sample_to_source(fx2, "fx2");
	sample_to_source(fx3, "fx3");
	bitmap_to_source(mine, "mine");
	bitmap_to_source(logo, "logo");
	bitmap_to_source(flow, "flower");
	bitmap_to_source(arrow, "arrow");
	bitmap_to_source(texture, "texture");
	bitmap_to_source(start, "start");
	bitmap_to_source(options, "options");
	bitmap_to_source(hall, "hall");
	bitmap_to_source(help, "help");
	bitmap_to_source(quit, "quit");
	bitmap_to_source(footer, "footer");
	finalize();
	return 0;
}
END_OF_MAIN()


void initialize() {
	allegro_init();
	install_keyboard(); 
	install_mouse();
	install_timer();
	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
	set_color_depth(24);
	set_gfx_mode(GFX_AUTODETECT_WINDOWED,320,200,0,0);
	text_mode(-1);
	srand((unsigned) time(NULL));
}


void finalize() {
	remove_sound();
	remove_timer();
	remove_mouse();
	remove_keyboard();
	allegro_exit();
}
