#include "SourceData.h"
#include <stdio.h>
#include <string.h>


BITMAP *source_to_bitmap(SOURCE_BITMAP* sbmp) {
	BITMAP *bmp = create_bitmap(sbmp->w, sbmp->h);
	for (int i=0; i<sbmp->h; i++) {
		for (int j=0; j<sbmp->w; j++) {
			putpixel(bmp, j, i, sbmp->dat[i * sbmp->w + j]);
		}
	}
	return bmp;
}


void bitmap_to_source(BITMAP* bmp, char* name) {
	char file[50];
	strcpy(file, name);
	strcat(file, ".h");
	FILE *f = fopen(file, "wt");
	fprintf(f, "int %s_data[] = {\n", name);
	for (int i=0; i<bmp->h; i++) {
		for (int j=0; j<bmp->w; j++) {
			fprintf(f, "0x%X", getpixel(bmp, j, i));
			if(! (j == bmp->w - 1 && i == bmp->h - 1))
				fprintf(f, ",");
		}
		fprintf(f, "\n");
	}
	fprintf(f, "};\n\n");
	fprintf(f, "SOURCE_BITMAP %s = { %d, %d, %s_data};\n", name, bmp->w, bmp->h, name);
	fclose(f);
}


MIDI *source_to_midi(SOURCE_MIDI* smidi) {
	MIDI *midi = (MIDI *) malloc(sizeof(MIDI));
	midi->divisions = smidi->divisions;
	for (int i=0; i<MIDI_TRACKS; i++) {
		midi->track[i].data = smidi->track[i].data;
		midi->track[i].len = smidi->track[i].len;
	}
	return midi;
}

void midi_to_source(MIDI* midi, char* name) {
	int i;
	char file[50];
	strcpy(file, name);
	strcat(file, ".h");
	FILE *f = fopen(file, "wt");
	for (i=0; i<MIDI_TRACKS; i++) {
		if (midi->track[i].len > 0) {
			fprintf(f, "unsigned char %s_data%d[] = {", name, i);
			for (int j=0; j<midi->track[i].len; j++) {
				fprintf(f, "0x%X", midi->track[i].data[j]);
				if(j != midi->track[i].len - 1)
					fprintf(f, ",");
				if((j+1)%50 == 0) 
					fprintf(f, "\n");
			}
			fprintf(f, "};");
		}
		else {
			fprintf(f, "unsigned char * %s_data%d = NULL;", name, i);
		}
		fprintf(f, "\n\n");
	}
	fprintf(f, "SOURCE_MIDI %s = {", name);
	fprintf(f, " %d, {\n", midi->divisions);
	for (i=0; i<MIDI_TRACKS; i++) {
		fprintf(f, "{ zombie_data%d, %d}", i, midi->track[i].len);
		if (i != MIDI_TRACKS - 1) 
			fprintf(f, ",");
		fprintf(f, "\n");
	}
	fprintf(f, "}\n};\n");
	fclose(f);
}


SAMPLE *source_to_sample(SOURCE_SAMPLE* ssam) {
	//SAMPLE *sam = create_sample(ssam->bits, ssam->stereo, ssam->freq, ssam->len);
	SAMPLE *sam = (SAMPLE*) malloc(sizeof(SAMPLE));
	sam->bits = ssam->bits;
	sam->stereo = ssam->stereo;
	sam->freq = ssam->freq;
	sam->len = ssam->len;
	sam->data = ssam->data;
	lock_sample(sam);
	return sam;
}


void sample_to_source(SAMPLE* sam, char* name) {
	int i;
	char file[50];
	strcpy(file, name);
	strcat(file, ".h");
	FILE *f = fopen(file, "wt");
	fprintf(f, "unsigned char %s_data[] = {\n", name);
	int bytes = sam->len * sam->bits / 8 * (sam->stereo? 2 : 1);
	for (i=0; i<bytes; i++) {
		fprintf(f, "%d", ((unsigned char*)sam->data)[i]);
		if (i != bytes - 1)
			fprintf(f, ",");
		if((i+1)%50 == 0) 
			fprintf(f, "\n");
	}
	fprintf(f, "\n};\n\n");
	fprintf(f, "SOURCE_SAMPLE %s = { ", name);
	fprintf(f, "%d, %d, %d, %d, %s_data};\n", sam->bits, sam->stereo, sam->freq, sam->len, name);
	fclose(f);
}

