#ifndef MINES_FLOWERS_TABLE_H
#define MINES_FLOWERS_TABLE_H

/** Class that represent a table of the game */

class MinesFlowersTable {
	private:
		/** Dimensions of table */
		int w, h;
		/** Allow circular push propagation */
		bool circular;
		/** Randomize table on restart */
		bool random_start;
		/** Dynamic array containing the status of cells */
		bool *dat;
	public:
		/** Constructor */
		MinesFlowersTable(int w, int h, bool circular, bool random_start);
		/** Destructor */
		~MinesFlowersTable();
		/** Reset all the table */
		void clear();
		/** Restart the table according to parameter random_start */
		void restart();
		/** Checks if the table is solved */
		bool check();
		/** Sets a cell of the table */
		void set(int x, int y, bool s);
		/** Gets the status of a cell of the table */
		bool get(int x, int y);
		/** Pushes a cell (toggles that cell and the near ones) */
		void push(int n);
		/** Pushes a cell (toggles that cell and the near ones) */
		void push(int x, int y);
		/** Invert the status of a cell */
		void change(int x, int y);
		/** Randomize the table */
		void randomize();
		/** Returns the size of the table (width x height) */
		int size();
		/** Returns the width of the table */
		int width();
		/** Return the height of the table */
		int height();
};

#endif
