#include "MinesFlowersTable.h"
#include <allegro.h>

MinesFlowersTable::MinesFlowersTable(int w, int h, bool circular, bool random_start) : w(w), h(h), circular(circular), random_start(random_start) {
	dat = new bool[w * h];
	clear();
}

MinesFlowersTable::~MinesFlowersTable() {
	delete [] dat;
}

void MinesFlowersTable::set(int x, int y, bool s) {
	dat[x * h + y] = s;
}

bool MinesFlowersTable::get(int x, int y) {
	return dat[x * h + y];
}

void MinesFlowersTable::push(int n) {
	push(n / w, n % w);
}

void MinesFlowersTable::push(int x, int y) {
	change(x, y);
	change(x, y - 1);
	change(x, y + 1);
	change(x + 1, y);
	change(x - 1, y);
}

void MinesFlowersTable::change(int x, int y) {
	if (!circular) {
		if ( x>=0 && x<w && y>= 0 && y<h) 
			set(x, y, ! get(x, y));
	}
	else {
		if (x < 0) x += w;
		if (y < 0) y += h;
		if (x >= w) x -= w;
		if (y >= h) y -= h;
		set(x, y, ! get(x,y));
	}
}

void MinesFlowersTable::randomize() {
	int num = w * h / 2;
	for (int i=0; i<num; i++) {
		int x = rand() % w;
		int y = rand() % h;
		push(x, y);
	}
}

void MinesFlowersTable::clear() {
	for (int i=0; i<w; i++) 
		for (int j=0; j<h; j++) 
			set(i, j, false);
}

bool MinesFlowersTable::check() {
	bool ck = true;
	for (int i=0; i<w; i++) 
		for (int j=0; j<h; j++) 
			if (get(i, j) == false) {
				ck = false;
				break;
			}
	return ck;
}

int MinesFlowersTable::size() {
	return w * h;
}

int MinesFlowersTable::width() {
	return w;
}

int MinesFlowersTable::height() {
	return h;
}

void MinesFlowersTable::restart() {
	clear();
	if (random_start) randomize();
}
