#ifndef DIALOG_MANAGER_H
#define DIALOG_MANAGER_H

#include <allegro.h>
#include "MinesFlowersTable.h"
#include "MinesFlowersOptions.h"
#include "MinesFlowersScoreTable.h"


/** Class that handles dialogs in the game */

class DialogManager {
	private:
		/** The main dialog */
		DIALOG *dlg_main;
		/** The dialog player */
		DIALOG_PLAYER *player;
		/** The index of the first cell object */
		int first;
		/** Counts the non-null items of a dialog */
		static int num_objects(DIALOG *dlg);
		/** Bitmaps used in the dialogs */
		BITMAP *bmp_logo, *bmp_mine, *bmp_flower, *bmp_arrow;
		BITMAP *bmp_texture, *bmp_back, *bmp_footer;
		BITMAP *bmp_start, *bmp_options, *bmp_hall, *bmp_help, *bmp_quit;
		/** Previos mouse button status */
		int p_mouse_b;
		/** Current time */
		int cur_time;
		/** String to contain time */
		char time_buf[20];
		/** String to contain size */
		char size_buf[5];
		/** String to contain high scores */
		char hof_buf[300];
		/** String that contains the name */
		char name_buf[30];
		/** Sets the high socres dialog */
		void set_dialog_hall(int size, bool circular, bool random, MinesFlowersScoreTable &mfst);
	public:
		/** Prepares the images */
		void prepare_images();
		/** Prepares mouse cursor */
		void prepare_mouse();
		/** Prepares the dialog following table dimensions */
		void create_dialog(MinesFlowersTable& mft);
		/** Updates the dialog */
		int update_dialog();
		/** Redraws the dialog */
		void redraw_dialog();
		/** Closes the dialog */
		void close_dialog();
		/** Updates the table, changing the cells status */
		void update_table(MinesFlowersTable& mft);
		/** Return the object index of the first cell */
		int first_cell();
		/** Shows options dialog */
		bool show_dialog_options(MinesFlowersOptions& mfo);
		/** Shows help dialog */
		void show_dialog_help();
		/** Shows the wineer dialog box */
		char* show_dialog_winner(int score);
		/** Shows the hall of fame dialog box */
		void show_dialog_hiscores(int size, bool circular, bool random, MinesFlowersScoreTable &mfst);
		/** Updates the time */
		void update_time(int t);
};


#endif
