#include "DataOutputStream.h"
#include <string.h>

DataOutputStream::DataOutputStream(char *name) throw (StreamException) {
	f = fopen(name, "wb");
	if (!f) throw StreamException();
}


DataOutputStream::~DataOutputStream() {
	fclose(f);
}


void DataOutputStream::writeBool(bool data) {
	fwrite(&data, sizeof(bool), 1, f);
}


void DataOutputStream::writeChar(char data) {
	fwrite(&data, sizeof(char), 1, f);
}


void DataOutputStream::writeInt(int data) {
	fwrite(&data, sizeof(int), 1, f);
}


void DataOutputStream::writeFloat(float data) {
	fwrite(&data, sizeof(float), 1, f);
}


void DataOutputStream::writeDouble(double data) {
	fwrite(&data, sizeof(double), 1, f);
}


void DataOutputStream::writeString(char *data) {
	int len = strlen(data);
	fwrite(&len, sizeof(int), 1, f);
	fwrite(data, sizeof(char), len, f);
}
