#include "SoundManager.h"
#include "SourceData.h"
#include "data/zombie.h"
#include "data/fx1.h"
#include "data/fx2.h"
#include "data/fx3.h"

SoundManager::SoundManager() : midi (NULL), playing(false) {
}

void SoundManager::prepare_music() {
	midi = source_to_midi(&zombie);
}

void SoundManager::prepare_sounds() {
	sam_fx1 = source_to_sample(&fx1);
	sam_fx2 = source_to_sample(&fx2);
	sam_fx3 = source_to_sample(&fx3);
}

void SoundManager::play_music() {
	if (!playing) play_midi(midi, 1);
	playing = true;
}

void SoundManager::stop_music() {
	if (playing) stop_midi();
	playing = false;
}

void SoundManager::play_sound(int code) {
	SAMPLE *s = NULL;
	switch(code) {
		case 1: s = sam_fx1; break;
		case 2: s = sam_fx2; break;
		case 3: s = sam_fx3; break;
	}
	if (s) play_sample(s, 255, 128, 1000, 0);
}
