#ifndef SOURCE_DATA_H
#define SOURCE_DATA_H

#include <allegro.h>

/** Struct to create images from C source files */
typedef struct SOURCE_BITMAP {
	int w, h;
	int *dat;
} SOURCE_BITMAP;

/** Struct to create midis from C source files */
typedef struct SOURCE_MIDI {
   int divisions;                      /* number of ticks per quarter note */
   struct {
      unsigned char *data;             /* MIDI message stream */
      int len;                         /* length of the track data */
   } track[MIDI_TRACKS];
} SOURCE_MIDI;

/** Struct to create samples from C source files */
typedef struct SOURCE_SAMPLE {
	int bits, stereo, freq, len;
	unsigned char *data;
} SOURCE_SAMPLE;


/** Converts a source bitmap to a bitmap */
BITMAP *source_to_bitmap(SOURCE_BITMAP* sbmp);
/** Save a bitmap in a C source file */
void bitmap_to_source(BITMAP* bmp, char* name);

/** Converts a source midi to a midi */
MIDI *source_to_midi(SOURCE_MIDI* smidi);
/** Save a midi in a C source file */
void midi_to_source(MIDI* midi, char* name);

/** Converts a source sample to a sample */
SAMPLE *source_to_sample(SOURCE_SAMPLE* ssam);
/** Save a sample in a C source file */
void sample_to_source(SAMPLE* sam, char* name);

#endif
