/* ------------------------------- */
/*                                 */
/* Mines and Flowers               */
/*                                 */
/* by Marco Chiesi                 */
/* e-mail:   chiesi@libero.it      */
/* web site: http://chiesi.cjb.net */
/*                                 */
/* Game created for                */
/* Allegro Speedhack 2002          */
/* ------------------------------- */


#include <allegro.h>

#include "MinesFlowersTable.h"
#include "MinesFlowersOptions.h"
#include "MinesFlowersTimer.h"
#include "DialogManager.h"
#include "SoundManager.h"

extern "C" {
#include "agup/agup.h"
#include "agup/aphoton.h"
}

/** Functions declations */

void initialize(bool win);
void finalize();


/** Main function */

int main(int argc, char *argv[]) {
	initialize(argc >= 2);
	MinesFlowersOptions mfo;
	mfo.load();
	MinesFlowersTable *mft = new MinesFlowersTable(mfo.size, mfo.size, mfo.circular, mfo.random);
	MinesFlowersTimer mftimer;
	MinesFlowersScoreTable mfst;
	DialogManager dm;
	SoundManager sm;
	mfst.load();
	mft->restart();
	dm.prepare_images();
	dm.prepare_mouse();
	dm.create_dialog(*mft);
	dm.update_table(*mft);
	sm.prepare_music();
	sm.prepare_sounds();
	if (mfo.music) sm.play_music();
	bool end = false;
	mftimer.start();
	do {
		int obj = dm.update_dialog();
		if (mft->check()) {
			int score = mftimer.get();
			sm.play_sound(3);
			if(mfst.insert(mfo.size, mfo.random, mfo.circular, score, dm.show_dialog_winner(score)))
				dm.show_dialog_hiscores(mfo.size, mfo.circular, mfo.random, mfst);
			mfst.save();
			mft->restart();
			mftimer.start();
			dm.update_table(*mft);
			dm.redraw_dialog();
			continue;
		}
		dm.update_time(mftimer.get());
		int cell = obj - dm.first_cell();
		if (cell >= 0 && cell < mft->size()) {
			if (mfo.sound) {
				sm.play_sound(mft->get(cell / mft->width(), cell % mft->width())? 2 : 1);
			}
			mft->push(cell);
			dm.update_table(*mft);
		}
		switch (obj) {
			case 3:
				mft->restart();
				mftimer.start();
				dm.update_table(*mft);
				break;
			case 4:
				if (dm.show_dialog_options(mfo)) {
					mfo.save();
					delete mft;
					mft = new MinesFlowersTable(mfo.size, mfo.size, mfo.circular, mfo.random);
					mft->restart();
					dm.close_dialog();
					dm.create_dialog(*mft);
					dm.update_table(*mft);
					if (mfo.music) sm.play_music();
					else sm.stop_music();
					mftimer.start();
				}
				dm.redraw_dialog();
				break;
			case 5:
				dm.show_dialog_hiscores(mfo.size, mfo.circular, mfo.random, mfst);
				dm.redraw_dialog();
				break;
			case 6:
				dm.show_dialog_help();
				dm.redraw_dialog();
				break;
			case 7:
			case 8:
				end = true; break;
		}
		yield_timeslice();
	}
	while (!end);
	dm.close_dialog();
	delete mft;
	finalize();
	return 0;
}
END_OF_MAIN()


// ------------------------------
//  Functions implementation
// ------------------------------

void initialize(bool win) {
	allegro_init();
	install_keyboard(); 
	install_mouse();
	install_timer();
	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
	int depth = desktop_color_depth();
	int first = (depth == 32) ? 32 : 24; 
	int seq [] = {first, 56 - first, 16, 15};
	bool ok = false;
	for (int i=0; i<2; i++) {
		int mode = i == 0? 
			(win? GFX_AUTODETECT_WINDOWED : GFX_AUTODETECT_FULLSCREEN):
			(win? GFX_AUTODETECT_FULLSCREEN : GFX_AUTODETECT_WINDOWED);
		for (int j=0; j<4; j++) {
				set_color_depth(seq[i]);
				ok = (set_gfx_mode(mode, 640, 480, 0, 0) >= 0);
				if (ok) break;
		}
		if (ok) break;
	}
	if(!ok) {
			allegro_message("Unable to set graphics mode");
			allegro_exit();
	}
	text_mode(-1);
	agup_init(aphoton_theme);
	gui_fg_color = agup_fg_color;
	gui_bg_color = agup_bg_color;
	gui_shadow_box_proc = d_agup_shadow_box_proc;
	gui_button_proc = d_agup_button_proc;
	gui_edit_proc = d_agup_edit_proc;
	gui_text_list_proc = d_agup_text_list_proc;
	srand((unsigned) time(NULL));
	set_window_title("Mines and flowers");
	set_display_switch_mode(SWITCH_BACKGROUND);
	set_volume(255, 255);
	set_mouse_speed(2, 2);
}

void finalize() {
	agup_shutdown();
	remove_sound();
	remove_timer();
	remove_mouse();
	remove_keyboard();
	allegro_exit();
}
