#include <stdio.h>
#include <string.h>
#include "DialogManager.h"
extern "C" {
#include "agup/agup.h"
}
#include "Dialog.h"
#include "Data.h"

int button_clicked(DIALOG *d) {
	return D_CLOSE;
}

int DialogManager::num_objects(DIALOG* dlg) {
	DIALOG *d = dlg;
	int c = 0;
	while (d->proc != NULL) {
		c++;
		d++;
	}
	return c;
}

void DialogManager::create_dialog(MinesFlowersTable& mft) {
	int bw = 36; // Table buttons width
	int bh = 36; // Table buttons height
	int i = 0;   // Current dialog object index
	int n = num_objects(dlg_base);
	int x_center = 404;
	int y_center = 240;
	int x_start = (int)(x_center - ((float) mft.width()) / 2 * bw);
	int y_start = (int)(y_center - ((float) mft.height()) / 2 * bh);
	// Creating store for sialog
	dlg_main = new DIALOG[mft.size() + n + 1];
	// Updating base dialog
	dlg_base[0].dp = bmp_back;
	dlg_base[1].dp = bmp_logo;
	dlg_base[2].dp = bmp_footer;
	dlg_base[3].dp = bmp_start;
	dlg_base[4].dp = bmp_options;
	dlg_base[5].dp = bmp_hall;
	dlg_base[6].dp = bmp_help;
	dlg_base[7].dp = bmp_quit;
	for (int k=3; k<8; k++)
		dlg_base[k].dp3 = (void*) button_clicked;
	// Adding base object to the main dialog
	for (int j=0; j<n; j++) 
		dlg_main[i++] = dlg_base[j];
	// Adding cell buttons to dialog
	first = i;
	for (int x=0; x<mft.width(); x++) {
		for (int y=0; y<mft.height(); y++) {
			DIALOG d = {
			/* (dialog proc)  (x)               (y)               (w) (h) (fg)  (bg) (key) (flags)  (d1) (d2)  (dp) (dp2) (dp3) */
			d_agup_icon_proc, x_start + bw * x, y_start + bh * y, bw, bh,   0,   0,    0,  D_EXIT,    1,   1,  bmp_mine, NULL, NULL 
			};
			dlg_main[i++] = d;
		}
	}
	// Adding null terminator to dialog
	dlg_main[i++] = dlg_base[n];
	// Initialize the dialog plaeyr
	player = init_dialog(dlg_main, -1);
}

void DialogManager::update_table(MinesFlowersTable& mft) {
	int i = first;
	for (int x=0; x<mft.width(); x++) {
		for (int y=0; y<mft.height(); y++) {
			BITMAP *b = mft.get(x, y)? bmp_flower : bmp_mine;
			if (dlg_main[i].dp != (void*)(b)) {
				dlg_main[i].dp = (void*)b;
				dlg_main[i].flags |= D_DIRTY;
			}
			i++;
		}
	}
}

void DialogManager::redraw_dialog() {
	int h;
	dialog_message(dlg_main, MSG_DRAW, 0, &h);
}

int DialogManager::update_dialog() {
	int sel = -1, ret = -1;
	int x = mouse_x;
	int y = mouse_y;
	int b = (mouse_b & 1) | (mouse_b & 2);
	for (int i=0; i<5; i++) {
		if (x >= dlg_main[3 + i].x && x < dlg_main[3 + i].x + dlg_main[3 + i].w) {
			if (y >= dlg_main[3 + i].y && y < dlg_main[3 + i].y + dlg_main[3 + i].h) {
				sel = i;
				break;
			}
		}
	}
	if (sel >= 0 && !b && p_mouse_b) {
		ret = sel + 3;
	}
	else if (::update_dialog(player) == FALSE) {
		ret = player->obj;
	};
	p_mouse_b = b;
	return ret;
}

void DialogManager::close_dialog() {
	shutdown_dialog(player);
	delete [] dlg_main;
}

int DialogManager::first_cell() {
	return first;
}

void DialogManager::prepare_images() {
	bmp_logo = source_to_bitmap(&logo);
	bmp_mine = source_to_bitmap(&mine);
	bmp_flower = source_to_bitmap(&flower);
	bmp_arrow = source_to_bitmap(&arrow);
	bmp_texture = source_to_bitmap(&texture);
	bmp_start = source_to_bitmap(&start);
	bmp_options = source_to_bitmap(&options);
	bmp_hall = source_to_bitmap(&hall);
	bmp_help = source_to_bitmap(&help);
	bmp_quit = source_to_bitmap(&quit);
	bmp_footer = source_to_bitmap(&footer);
	bmp_back = create_bitmap(SCREEN_W, SCREEN_H);
	drawing_mode(DRAW_MODE_COPY_PATTERN, bmp_texture, 0, 0);
	rectfill(bmp_back, 0, 0, SCREEN_W - 1, SCREEN_H - 1, 0);
	drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
	strcpy(name_buf, "Mr. Flower");
	cur_time = 0;
}

void DialogManager::prepare_mouse() {
	set_mouse_sprite(bmp_arrow);
	set_mouse_sprite_focus(0, 0);
	show_mouse(screen);
}

bool DialogManager::show_dialog_options(MinesFlowersOptions& mfo) {
	char buf[5];
	// Set up dialog objects values
	if (mfo.circular) dlg_options[5].flags |= D_SELECTED;
	else dlg_options[5].flags &= ~D_SELECTED;
	if (mfo.random) dlg_options[6].flags |= D_SELECTED;
	else dlg_options[6].flags &= ~D_SELECTED;
	if (mfo.music) dlg_options[11].flags |= D_SELECTED;
	else dlg_options[11].flags &= ~D_SELECTED;
	if (mfo.sound) dlg_options[12].flags |= D_SELECTED;
	else dlg_options[12].flags &= ~D_SELECTED;
	int size = mfo.size;
	sprintf(buf, "%d",size);
	dlg_options[9].dp  = (void *) buf;
	dlg_options[7].dp3 = (void *) button_clicked;
	dlg_options[8].dp3 = (void *) button_clicked;
	dlg_options[13].dp3 = (void *) button_clicked;
	dlg_options[14].dp3 = (void *) button_clicked;
	dlg_options[13].key = scancode_to_ascii(KEY_ENTER);
	dlg_options[14].key = scancode_to_ascii(KEY_ESC);
	// Display the dialog
	bool end = false;
	DIALOG_PLAYER *dp = init_dialog(dlg_options, -1);
	do {
		if (::update_dialog(dp) == FALSE) {
			switch (dp->obj) {
			case  13:
			case  14: end = true; break;
			case  7: if (size>3) size--; break;
			case  8: if (size<12) size++; break; 
			}
			if ((dp->obj == 7) || (dp->obj == 8)) {
				dlg_options[dp->obj].flags &= ~D_SELECTED;
				dlg_options[dp->obj].flags |= D_DIRTY;
				sprintf(buf, "%d", size);
				dlg_options[9].dp  = (void *) buf;
				dlg_options[9].flags |= D_DIRTY;
			}
		}
	}
	while (!end);
	int r = dp->obj;
	// Updates options
	if (r == 13) {
		mfo.circular = (dlg_options[5].flags & D_SELECTED)? true : false;
		mfo.random   = (dlg_options[6].flags & D_SELECTED)? true : false;
		mfo.music    = (dlg_options[11].flags & D_SELECTED)? true : false;
		mfo.sound    = (dlg_options[12].flags & D_SELECTED)? true : false;
		mfo.size     = size;
	}
	shutdown_dialog(dp);
	return (r == 13);
}

void DialogManager::show_dialog_help() {
	dlg_help[1].dp = (void*) "\
-------------------------\n\
MINES AND FLOWERS [v.1.1]\n\
-------------------------\n\
\n\
Code:\n\
Marco Chiesi\n\
chiesi@libero.it\n\
http://chiesi.cjb.net\n\
\n\
Graphics:\n\
Francesco Canovi\n\
francesco.canovi@libero.it\n\
http://www.blackstudio.it\n\
\n\
This game was written in a weekend for the Allegro Speedhack 2002 competition.\n\
The rules were:\n\
- The game should be made with the Allegro library (obviously)\n\
- The game should not have any external data\n\
- The game should exude a message of peace, love and mutual respect\n\
\n\
Visit http://www.allegro.cc/speedhack for more info.\n\
\n\
------------------\n\
OBJECT OF THE GAME\n\
------------------\n\
This is a puzzle game with simple rules. You have a grid with mines and flowers.\n\
The object of the game is to turn all the mines on the grid into flowers.\n\
When you click on a cell with a mine, that one and the four adjacent \
cells will change to a flower and viceversa.\n\
I hope you enjoy it even if it is more difficult to solve than it seems.\n\
\n\
-------\n\
OPTIONS\n\
-------\n\
- Circular grid: this option makes the edge cells to switch those \
that are on the opposite side of the grid.\n\
- Random start: this option lets the game start from a random configuration \
of mines and flower, otherwise it starts with a grid full of mines\n\
- Size: the number of cells for every side of the grid.\n\
\n\
-----\n\
HINTS\n\
-----\n\
If you start the game with both options disabled \
there are rules that you may follow to simplify the solution of the game:\n\
1) Depending on the size of the grid, for most cases there is just one solution. \
In this case you have to click all the cells along the two diagonals\n\
2) If the size is an odd number and the solution is only one, click also on the cells \
in the central column and row, leaving two not clicked cells between a click \
and the other, following the pattern\n\
x o o x o o x\n\
3) Don't click again on the cells you have already clicked, but continue \
only clicking the others.\n\
\n\
-------\n\
CREDITS\n\
-------\n\
Thanks to:\n\
- All the Allegro Community\n\
- Peter Wang for AGUP Library\n\
- J. Cugniere for dlg editor\n\
- The Cranberries for the music\n\
";
	dlg_help[2].dp3 = (void *) button_clicked;
	dlg_help[2].key = scancode_to_ascii(KEY_ENTER);
	popup_dialog(dlg_help, -1);
}

char* DialogManager::show_dialog_winner(int score) {
	char label[20];
	sprintf(label, "Time: %d", score);
	dlg_winner[1].dp = (void*) name_buf;
	dlg_winner[2].dp3 = (void *) button_clicked;
	dlg_winner[2].key = scancode_to_ascii(KEY_ENTER);
	dlg_winner[3].dp = (void*) label;
	popup_dialog(dlg_winner, -1);
	return (char *)(dlg_winner[1].dp);
}

void DialogManager::set_dialog_hall(int size, bool circular, bool random, MinesFlowersScoreTable &mfst) {
	char buf[30];
	sprintf(size_buf, "%d",size);
	MinesFlowersScore& mfs = mfst.get(size, random, circular);
	strcpy(hof_buf, "");
	for (int i=0; i<NUM_HISCORES; i++) {
		sprintf(buf, "%-20s %5d\n", mfs.get_name(i), mfs.get_score(i));
		strcat(hof_buf, buf);
	}
	dlg_hall[6].dp = (void*) size_buf;
	dlg_hall[7].dp = (void*) hof_buf;
	if (circular) dlg_hall[2].flags |= D_SELECTED;
	else dlg_hall[2].flags &= ~D_SELECTED;
	if (random) dlg_hall[3].flags |= D_SELECTED;
	else dlg_hall[3].flags &= ~D_SELECTED;
	dlg_hall[2].dp3 = (void *) button_clicked;
	dlg_hall[3].dp3 = (void *) button_clicked;
	dlg_hall[4].dp3 = (void *) button_clicked;
	dlg_hall[5].dp3 = (void *) button_clicked;
	dlg_hall[8].dp3 = (void *) button_clicked;
	dlg_hall[2].flags |= D_DIRTY;
	dlg_hall[3].flags |= D_DIRTY;
	dlg_hall[4].flags |= D_DIRTY;
	dlg_hall[5].flags |= D_DIRTY;
	dlg_hall[6].flags |= D_DIRTY;
	dlg_hall[7].flags |= D_DIRTY;
	dlg_hall[8].key = scancode_to_ascii(KEY_ENTER);
}

void DialogManager::show_dialog_hiscores(int size, bool circular, bool random, MinesFlowersScoreTable &mfst) {
	set_dialog_hall(size, circular, random, mfst);
	bool end = false;
	DIALOG_PLAYER *dp = init_dialog(dlg_hall, -1);
	do {
		if (::update_dialog(dp) == FALSE) {
			switch (dp->obj) {
			case  8: end = true; break;
			case  2: circular = ! circular; break; 
			case  3: random = ! random; break; 
			case  4: if (size>3) size--; break;
			case  5: if (size<12) size++; break; 
			}
			if ((dp->obj >= 2) && (dp->obj <= 5)) {
				set_dialog_hall(size, circular, random, mfst);
			}
		}
	}
	while (!end);
	shutdown_dialog(dp);
}

void DialogManager::update_time(int t) {
	if (cur_time == t) return;
	cur_time = t;
	int w = 70;
	int h = 14;
	int x = 8;
	int y = 465;
	BITMAP *bmt = create_bitmap(w, h);
	rectfill(bmt, 0, 0, w - 1, h - 1, 0);
	rectfill(bmt, 2, 2, w - 3, h - 3, 0xFFFF00);
	textprintf_centre(bmt, font, w/2, 3, 0, "%d", t);
	scare_mouse_area(x, y, x + w, y + h);
	blit(bmt, screen, 0, 0, x, y, w, h);
	unscare_mouse();
	destroy_bitmap(bmt);
	/*
	sprintf(time_buf, "Time: %2d", t);
	dlg_main[9].dp = time_buf;
	dlg_main[9].flags |= D_DIRTY;
	*/
}
