#include "DataInputStream.h"
#include <string.h>

DataInputStream::DataInputStream(char *name) throw (StreamException) {
	f = fopen(name, "rb");
	if (!f) throw StreamException();
}


DataInputStream::~DataInputStream() {
	fclose(f);
}


bool DataInputStream::readBool() {
	bool data;
	fread(&data, sizeof(bool), 1, f);
	return data;
}


char DataInputStream::readChar() {
	char data;
	fread(&data, sizeof(char), 1, f);
	return data;
}


int DataInputStream::readInt() {
	int data;
	fread(&data, sizeof(int), 1, f);
	return data;
}


float DataInputStream::readFloat() {
	float data;
	fread(&data, sizeof(float), 1, f);
	return data;
}


double DataInputStream::readDouble() {
	double data;
	fread(&data, sizeof(double), 1, f);
	return data;
}


char * DataInputStream::readString(char *s) {
	int len = readStringLength();
	return readStringChars(s, len);
}


int DataInputStream::readStringLength() {
	int len;
	fread(&len, sizeof(int), 1, f);
	return len;
}


char * DataInputStream::readStringChars(char *s, int len) {
	if (len > 0) {
		fread(s, sizeof(char), len, f);
		s[len] = '\0';
	}
	else strcpy(s, "");
	return s;
}
