#ifndef FISHY_PATHS
#define FISHY_PATHS


#define CENTER_X (GAME_X + GAME_W/2)
#define CENTER_Y (HEIGHT / 2)
#define END_X    (GAME_X + GAME_W)

#define START           1
#define FLY_TO          2
#define CIRCLE_AROUND   3
#define ENTER_FORMATION 4

#define RADIUS
#define START_ANGLE(x) (x*255 / 360)
#define END_ANGLE(x) (x*255 / 360)
#define CLOCKWISE          1
#define COUNTER_CLOCKWISE  0


int pathDownCenterLeft[] = {
	START          , CENTER_X -  50, -50,
	FLY_TO         , CENTER_X -  50, CENTER_Y-50,
	CIRCLE_AROUND  , CENTER_X - 100, CENTER_Y-50, RADIUS 50, START_ANGLE(  0 ), END_ANGLE( 360 ),	
	CIRCLE_AROUND  , CENTER_X      , CENTER_Y-50, RADIUS 50, START_ANGLE(180 ), END_ANGLE(   0 ),	
	ENTER_FORMATION,
};

int pathDownCenterRight[] = {
	START          , CENTER_X +  50,           -50,
	FLY_TO         , CENTER_X +  50,   CENTER_Y-50,
	CIRCLE_AROUND  , CENTER_X + 100,   CENTER_Y-50, RADIUS 50, START_ANGLE( 180 ), END_ANGLE(-180 ),
	CIRCLE_AROUND  , CENTER_X      ,   CENTER_Y-50, RADIUS 50, START_ANGLE(   0 ), END_ANGLE( 180 ),	
	ENTER_FORMATION,
};

int pathLeftWave[] = {
	START          ,   GAME_X -  50, CENTER_Y,
	FLY_TO         ,   GAME_X +  50, CENTER_Y,
	CIRCLE_AROUND  ,   GAME_X +  50, CENTER_Y - 50, RADIUS 50, START_ANGLE(  90 ),  END_ANGLE(   0 ),
	CIRCLE_AROUND  ,   GAME_X + 150, CENTER_Y - 50, RADIUS 50, START_ANGLE( 180 ),  END_ANGLE( 540 ),
	ENTER_FORMATION,
};

int pathRightWave[] = {
	START          ,   END_X +  50, CENTER_Y,
	FLY_TO         ,   END_X -  50, CENTER_Y,
	CIRCLE_AROUND  ,   END_X -  50, CENTER_Y - 50, RADIUS 50, START_ANGLE(  90 ),  END_ANGLE( 180 ),
	CIRCLE_AROUND  ,   END_X - 150, CENTER_Y - 50, RADIUS 50, START_ANGLE( 360 ),  END_ANGLE(   0 ),
	ENTER_FORMATION,
};

int pathLeftEight[] = {
	START          ,   GAME_X - 50, 100,
	FLY_TO         ,   GAME_X + 50, 150,
	CIRCLE_AROUND  ,   GAME_X + 50, 100, RADIUS 50, START_ANGLE( 90 ), END_ANGLE (-270),
	CIRCLE_AROUND  ,   GAME_X + 50, 200, RADIUS 50, START_ANGLE(-90 ), END_ANGLE ( 270),
	ENTER_FORMATION,
};

int pathRightEight[] = {
	START          ,   END_X + 50, 100,
	FLY_TO         ,   END_X - 50, 150,
	CIRCLE_AROUND  ,   END_X - 50, 100, RADIUS 50, START_ANGLE( 90 ), END_ANGLE ( 450),
	CIRCLE_AROUND  ,   END_X - 50, 200, RADIUS 50, START_ANGLE(270 ), END_ANGLE ( -90),
	ENTER_FORMATION,
};

int pathLeftEightLow[] = {
	START          ,   GAME_X - 50, 300,
	FLY_TO         ,   GAME_X + 50, 350,
	CIRCLE_AROUND  ,   GAME_X + 50, 400, RADIUS 50, START_ANGLE(-90 ), END_ANGLE ( 270),
	CIRCLE_AROUND  ,   GAME_X + 50, 300, RADIUS 50, START_ANGLE( 90 ), END_ANGLE (-270),
	ENTER_FORMATION,
};

int pathRightEightLow[] = {
	START          ,   END_X + 50, 300,
	FLY_TO         ,   END_X - 50, 350,
	CIRCLE_AROUND  ,   END_X - 50, 400, RADIUS 50, START_ANGLE(270 ), END_ANGLE ( -90),
	CIRCLE_AROUND  ,   END_X - 50, 300, RADIUS 50, START_ANGLE( 90 ), END_ANGLE ( 450),
	ENTER_FORMATION,
};

int pathTopDown[] = {
	START , CENTER_X, -50,
	FLY_TO,	CENTER_X,  50,
    ENTER_FORMATION,
};

int pathUTurnLeft[] = {
	START        , GAME_X -  50,  50,
	FLY_TO       , END_X  - 100,  50,
	CIRCLE_AROUND, END_X  - 100, 100, RADIUS 50, START_ANGLE(270), END_ANGLE( 450 ),
	FLY_TO       , CENTER_X    ,  50,
	ENTER_FORMATION,
};

int pathUTurnRight[] = {
	START        , END_X  +  50,  50,
	FLY_TO       , GAME_X + 100,  50,
	CIRCLE_AROUND, GAME_X + 100, 100, RADIUS 50, START_ANGLE(270), END_ANGLE( 90 ),
	FLY_TO       , CENTER_X    ,  50,
	ENTER_FORMATION,
};

int pathUTurnLeftLow[] = {
	START        , GAME_X -  50, 350,
	FLY_TO       , END_X  - 100, 350,
	CIRCLE_AROUND, END_X  - 100, 300, RADIUS 50, START_ANGLE(90), END_ANGLE( -90 ),
	FLY_TO       , CENTER_X    , 250,
	ENTER_FORMATION,
};

int pathUTurnRightLow[] = {
	START        , END_X  +  50, 350,
	FLY_TO       , GAME_X + 100, 350,
	CIRCLE_AROUND, GAME_X + 100, 300, RADIUS 50, START_ANGLE( 90), END_ANGLE( 270 ),
	FLY_TO       , CENTER_X    , 250,
	ENTER_FORMATION,
};



typedef struct {
	int  attackerCount;
	int  attackerCountCur;
	int  attackerType;
	int  targetLine;
	int* path;
} WaveData;

#define LEVEL_COUNT 7
int waveCount [LEVEL_COUNT] = {2, 3  ,   2,   3,    2, 2    , 2};
int waveOffset[LEVEL_COUNT] = {0, 2*3, 5*3, 7*3, 10*3, 12*3 , 14*3};

#define WAVE_GROUP_COUNT 28

WaveData waveList[WAVE_GROUP_COUNT] = {
	{ 6, 6, 0, 1, pathLeftWave        }, 
	{ 6, 6, 0, 3, pathRightWave       }, 
	{ 6, 6, 2, 0, pathDownCenterLeft  }, 
	{ 6, 6, 2, 2, pathDownCenterRight }, 
	

	{ 6, 6, 0, 1, pathRightEight      },
	{ 6, 6, 0, 3, pathLeftEight       },
	{ 6, 6, 3, 0, pathRightEightLow   },
	{ 6, 6, 3, 2, pathLeftEightLow    },

	{ 6, 6, 1, 0, pathLeftEight       },	
	{ 6, 6, 1, 2, pathRightEight      },
	{ 6, 6, 0, 1, pathUTurnLeft       },
	{ 6, 6, 0, 3, pathUTurnRight      },

	{ 6, 6, 3, 3, pathTopDown         },
	{ 6, 6, 1, 2, pathUTurnRightLow   },
	{ 6, 6, 1, 1, pathUTurnLeftLow    },
	{ 6, 6, 4, 0, pathTopDown         },

	{ 6, 6, 2, 3, pathUTurnRightLow   },
	{ 6, 6, 2, 1, pathUTurnLeft       },
	{ 6, 6, 4, 0, pathLeftWave        }, 
	{ 6, 6, 4, 2, pathRightWave       }, 

	{ 6, 6, 1, 0, pathDownCenterLeft  }, 
	{ 6, 6, 0, 2, pathDownCenterRight },
	{ 6, 6, 2, 3, pathLeftEight       },
	{ 6, 6, 3, 1, pathRightEight      },

	{ 6, 6, 2, 1, pathUTurnLeft       },
	{ 6, 6, 3, 3, pathUTurnRight      },
	{ 6, 6, 1, 2, pathUTurnLeftLow    },
	{ 6, 6, 0, 3, pathUTurnRightLow   },
	
};	

int waveTimerList[16 *3] = {
	100, 2, 0, // Start time and number of individual waves + index of first enemy group
	100, 2, 2, //

	100, 1, 4,
	  0, 1, 5,
	100, 2, 6,

	100, 2, 8,
	100, 2,10,

	100, 1,12,
	100, 2,13,
	100, 1,15,

	100, 2,16,
	100, 2,18,

	100, 2,20,
	100, 2,22,

	100, 2,24,
	100, 2,26,

};

#endif
