#include <allegro.h>
#include <fmod.h>
#include <fmod_errors.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>


#define WIDTH  800
#define HEIGHT 600
#define GAME_X 200
#define GAME_W 400
#define GAME_END (GAME_X + GAME_W)
#define DAT_PREFIX 	"data/"

#define ENEMY_COUNT 5

#define SPRITE_STATE_STRAIGHT_MOVE 0
#define SPRITE_STATE_CIRCLE_MOVE   1
#define SPRITE_STATE_FETCH_MOVE    2
#define SPRITE_ENTER_FORMATION     4
#define SPRITE_FORMATION           5
#define SPRITE_ATTACK              6
#define SPRITE_HIT                 7
#define SPRITE_DEAD                8

#define ASSUMED_SPRITE_W           54

#define SHOOT_ADJUST_X             50
#define SHOOT_ADJUST_Y             20


char FONT_CHARS[]   = "!\"$%&/()=?*+#'_@:.0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
int  FONT_OFFSETS[] = {
    0, 5, 15, 29, 45, 60, 74, 84, 95, 104, 116, 128, 140, 162, 168, 188, 204, 211, 219,
    0, 12, 22, 35, 47, 60, 73, 85, 97, 109, 122,
    0, 13, 26, 41, 56, 68, 80, 95, 110, 119,127,142,152, 174, 190,207, 219, 237, 250, 264, 279, 294, 310, 330, 346, 361, 374
};


BITMAP *doubleBuffer;     
BITMAP *title;
BITMAP *tile;
BITMAP *fillPattern;
BITMAP *fontImg;
BITMAP **enemy;

BITMAP *bg;
BITMAP *bubble;
BITMAP *mermaid;
BITMAP *water;
BITMAP *fxBuffer;
BITMAP *arrow;
BITMAP *wellDone;
BITMAP *smallMermaid;
BITMAP *gameOver;


char stringBuffer[200];

FMUSIC_MODULE *gameMusic  = NULL;
FMUSIC_MODULE *titleMusic = NULL;
FSOUND_SAMPLE *shoot      = NULL;
FSOUND_SAMPLE *hit        = NULL;
FSOUND_SAMPLE *tataa      = NULL;
FSOUND_SAMPLE *theEnd     = NULL;
FSOUND_SAMPLE *hurt       = NULL;


typedef struct {
    int x, y;
} Point;

Point hero;
int   attackingFishs = 0;

typedef struct {
    int x, y;
    void *next;
    void *prev;
} Arrow;

Point bubbles[10];
int   bubbleSpeed[10];
int   formationX;
int   formationY;

typedef struct {
    void *data;
    void *next;
    void *prev;
} Node;

typedef struct {
    BITMAP *image;
    int    w,h;
    Point  pos;
    int    frame;

    int    state;
    int    lastState;

    int    id;
    int    line;

    Point  center;
    int    r;
    int    curAngle;
    int    destAngle;
    int    clockwise;   
    int    blink;

    float  fx, fy, dx, dy;

    int *code;

    void *next;
    void *prev;
} Sprite;

typedef struct {
    char name[4];
    int  score;
} Hiscore;

Hiscore hiscores[11];

#define FRAME_COUNT 6
int curFrame     = 0;
int frameOrder[] = {0,1,2,3,4,3,};
int transparentCol = 0;


volatile int timerCounter;
void myTimerHandler(void) {
    timerCounter++;
}
END_OF_FUNCTION(myTimerHandler);


volatile int fpsCounter;
void fpsTimer(void) {
    fpsCounter++;
}
END_OF_FUNCTION(fpsTimer);



int waveTable[256];

#include "path.h"

#define GREETINGS "MERMAID PANIC V1.1    WRITTEN OCTOBER 2001 IN AROUND 2 WEEKS    . . .   GREETINGS FLY TO MADGARDEN. TSUGUMO. SKYWISE. ECLIPZER AND ALL THE OTHER GDR GUYS...   /SPELLCASTER   ---   GAME COMES WITH FULL SOURCE"


void firstTimeInit() {

    int a=0;
    FILE *f;

    srand(clock());
    allegro_init();
    install_keyboard();
    //install_mouse();
    install_timer();    

    set_color_depth(16);
    if( set_gfx_mode(GFX_AUTODETECT, WIDTH, HEIGHT, 0, 0) <0 ) {
        set_color_depth(15);
        if( set_gfx_mode(GFX_AUTODETECT, WIDTH, HEIGHT, 0, 0) <0 ) {
            set_color_depth(16);
            if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, WIDTH, HEIGHT, 0, 0) <0) {
                allegro_message("Sorry, but you need a Hicolor mode (16 bit color depth) for this game.");
                exit(0);
            }
        }
    }

    LOCK_VARIABLE(timerCounter);
    LOCK_FUNCTION(myTimerHandler);

    LOCK_VARIABLE(fpsCounter);
    LOCK_FUNCTION(fpsTimer);

    install_int(myTimerHandler, 10);
    //install_int_ex(fpsTimer, BPS_TO_TIMER(30));
    install_int(fpsTimer, 20);

    doubleBuffer = create_bitmap(WIDTH, HEIGHT);        
    fxBuffer     = create_bitmap(WIDTH, HEIGHT+200);        

    if( !FSOUND_Init(44100, 32, FSOUND_INIT_GLOBALFOCUS) ) {
        allegro_message("Unable to init sound!");
        //printf("%s\n", FMOD_ErrorString(FSOUND_GetError()));
        exit(1);
    }

    transparentCol = makecol(0xff, 0, 0xff);


    for( a=0; a < 256; a++ ) {
        waveTable[a] = fixtoi(fsin(itofix(a))*2);
    }
    set_trans_blender(0, 0, 0,64);    

    memset(hiscores, 0, sizeof(Hiscore)*11);

    for( a=0; a < 10; a++ ) {
        strcpy(hiscores[a].name, "FOO");
    }
    if( exists("highscore.inf") ) {
        f= fopen("highscore.inf", "rb");
        fread(hiscores, sizeof(Hiscore), 10, f);
        fclose(f);
    } else {
        f= fopen("highscore.inf", "wb");
        fwrite(hiscores, sizeof(Hiscore), 10, f);
        fclose(f);
    }


}             

BITMAP* load_bitmap_(const char* name, void *pal) {
    BITMAP * bmp = load_bitmap(name, pal);
    if(bmp) {
        return bmp;
    }
    allegro_message("Unable to load %s", name);
    return NULL;
}

void loadImages() {
    int x,y,a;


    title       = load_bitmap(DAT_PREFIX "title.bmp"   , NULL);
    tile        = load_bitmap(DAT_PREFIX "bgtile.bmp"  , NULL);
    fillPattern = load_bitmap(DAT_PREFIX "fill.bmp"    , NULL);
    fontImg     = load_bitmap(DAT_PREFIX "font.bmp"    , NULL);     
    bg          = load_bitmap(DAT_PREFIX "bg.bmp"      , NULL);
    bubble      = load_bitmap(DAT_PREFIX "bubble01.bmp", NULL);
    mermaid     = load_bitmap(DAT_PREFIX "mermaid.bmp" , NULL);
    water       = load_bitmap(DAT_PREFIX "water.bmp"   , NULL);
    arrow       = load_bitmap(DAT_PREFIX "arrow.bmp"   , NULL);
    wellDone    = load_bitmap(DAT_PREFIX "welldone.bmp", NULL);
    smallMermaid= load_bitmap(DAT_PREFIX "small.bmp"   , NULL);
    gameOver    = load_bitmap(DAT_PREFIX "gameover.bmp"   , NULL);

    enemy = calloc(ENEMY_COUNT, sizeof(BITMAP*));
    for( a=0; a < ENEMY_COUNT; a++ ) {
        sprintf(stringBuffer, "%sfish%02i.bmp", DAT_PREFIX, (a+1));     
        //allegro_message(stringBuffer);
        enemy[a] = load_bitmap(stringBuffer  , NULL);
        //allegro_message("enemy %i: %s", a, enemy[a] == NULL ? "null" : "loaded");
    }

    for( y=0; y < fxBuffer->h; y+= water->h ) {
        for( x=0; x <= fxBuffer->w; x+= water->w ) {
            blit(water, fxBuffer, 0, 0, x, y, water->w, water->h);
        }
    }

    for( a=0; a < 10; a++ ) {
        bubbles[a].x = (rand()% GAME_W) + GAME_X;
        bubbles[a].y = HEIGHT + (rand()% 200);

        bubbleSpeed[a] = -1 - (rand()%4);
    }
}

void loadSounds() {
    titleMusic = FMUSIC_LoadSong("fishtro.s3m");
    gameMusic  = FMUSIC_LoadSong("dancing-water.xm");
    shoot      = FSOUND_Sample_Load(FSOUND_FREE, "shoot2.mp2"  , FSOUND_NORMAL, 0);
    hit        = FSOUND_Sample_Load(FSOUND_FREE, "hit.mp2"     , FSOUND_NORMAL, 0);
    tataa      = FSOUND_Sample_Load(FSOUND_FREE, "welldone.mp2", FSOUND_NORMAL, 0);
    theEnd     = FSOUND_Sample_Load(FSOUND_FREE, "end.mp2"     , FSOUND_NORMAL, 0);
    hurt       = FSOUND_Sample_Load(FSOUND_FREE, "hurt.mp2"    , FSOUND_NORMAL, 0);
}



// angle is in [0..256]
void calcRotation(Point* center, int angle, int radius, Point* result) {
    int a = itofix(angle);
    int x = fcos(a);
    int y = fsin(a);

    //radius = itofix(radius);

    x *= radius;
    y *= radius;

    result->x = center->x + fixtoi(x);
    result->y = center->y + fixtoi(y);
}



void drawSprite(Sprite* spr, BITMAP *dest) {
    int sx = 0; 
    int sy = 0;

    if( spr->state == SPRITE_HIT && spr->blink ) {
        spr->blink = 0;
        return;
    }
    spr->blink = !spr->blink;

    if( spr->state == SPRITE_FORMATION ) {
        sx = frameOrder[curFrame] * spr->w;
    }

    masked_blit(spr->image, dest, 
                sx, sy, 
                spr->pos.x - spr->w/2, spr->pos.y - spr->w/2, 
                48, 48);
}

void sendSpriteIntoLoop(Sprite *spr, int x, int y, int r, int start, int end) {

    spr->center.x  = x;
    spr->center.y  = y;
    spr->r         = r;

    spr->curAngle  = start;
    spr->destAngle = end;

    spr->clockwise = end > start;

    spr->state = SPRITE_STATE_CIRCLE_MOVE;
}

void sendSpriteOnMove(Sprite *spr, int x, int y) {


    int dx = x- spr->pos.x;
    int dy = y- spr->pos.y;

    spr->fx = spr->pos.x;
    spr->fy = spr->pos.y;

    spr->center.x = x;
    spr->center.y = y;


    if( ABS(dx) > ABS(dy) ) {
        if( dx >= 3 || dx <=-3 ) {
            spr->dx = 3.0 * (dx > 0 ? 1 : -1);
        } else {
            spr->dx = dx;
        }

        if( dx == 0 || dy == 0 ) {
            spr->dy = 0;
        } else {
            spr->dy = ((float) (ABS(dy))) / ((float) (ABS(dx)));            
            if( dy < 0 ) {
                spr->dy *= -1.0;
            }
        }        
        spr->dy = spr->dy * 3;
    } else {
        if( dy >= 3 || dy <=-3 ) {
            spr->dy = 3.0;
        } else {
            spr->dy = dx;
        }

        if( dy == 0 ) {
            spr->dx = 0;
        } else {
            spr->dx = ((float) (ABS(dx))) / ((float) (ABS(dy)));
            if( dx < 0 ) {
                spr->dx *= -1.0;
            }
        }
        spr->dx = spr->dx * 3;
    }

    spr->state = SPRITE_STATE_STRAIGHT_MOVE;


}

int handleArrow(BITMAP* dest, Arrow *p, Sprite *headSprite) {

    Sprite *curSprite = NULL;

    int    ax, ax2,ay,ay2,score;
    Point  *pos;

    int    col;


    p->y -= 8;
    ax = p->x;
    ay = p->y;
    ax2 = ax + arrow->w;
    ay2 = ay + arrow->h;



    curSprite = headSprite;
    while( curSprite != NULL ) {
        pos = &curSprite->pos;
        if( curSprite->state < SPRITE_HIT &&
            pos->x -24 < ax2 && 
            pos->x +24 > ax  && 
            pos->y -24 < ay2 && 
            pos->y +24 > ay ) {
            col = getpixel(curSprite->image, (ax - (pos->x-24)) + curSprite->w *curSprite->frame +2, ay- (pos->y-24)+4);

            if( col > 0 && col != transparentCol ) {

                if( curSprite->state < SPRITE_FORMATION ) {
                    score = 200;
                } else {
                    score = 50;
                }
                if( curSprite->state == SPRITE_ATTACK ) {
                    attackingFishs--;
                }
                curSprite->state    = SPRITE_HIT;
                curSprite->center   = curSprite->pos;
                curSprite->r        = 0;
                curSprite->curAngle = 0;

                FSOUND_PlaySound(FSOUND_FREE, hit);
                return score;
            }
        }
        curSprite = (Sprite*) curSprite->next;
    }

    if( p->y < - arrow->h ) {
        return 1;
    }
    return 0;
}


int handleSprite(Sprite* spr) {

    //FILE *f = fopen("debug.txt", "a");
    int x, y, r, sa, ea;

    int enteredFormation = 0;
    int justHit;

    if( spr->state == SPRITE_DEAD ) {
        return 0;
    }

    justHit =  (spr->state == SPRITE_HIT && spr->lastState < SPRITE_FORMATION);

    spr->lastState = spr->state;

    switch( spr->state ) {
        case SPRITE_STATE_CIRCLE_MOVE:
            calcRotation(&(spr->center), spr->curAngle, spr->r, &(spr->pos));

            if( spr->clockwise ) {
                spr->curAngle += 4;
                if( spr->curAngle >= spr->destAngle ) {
                    spr->state = SPRITE_STATE_FETCH_MOVE;
                }
            } else {
                spr->curAngle -= 4;
                if( spr->curAngle <= spr->destAngle ) {
                    spr->state = SPRITE_STATE_FETCH_MOVE;
                }
            }                            
            break;

        case SPRITE_ENTER_FORMATION:
            x = formationX + GAME_X + spr->id * (ASSUMED_SPRITE_W) + ASSUMED_SPRITE_W/2;
            y = formationY + spr->line * 70 + 100;
            if( spr->pos.x < x ) {
                spr->pos.x += 3;
                if( spr->pos.x > x ) {
                    spr->pos.x = x;
                    enteredFormation++;
                }
            } else if( spr->pos.x > x ) {
                spr->pos.x -= 3;
                if( spr->pos.x < x ) {
                    spr->pos.x = x;
                    enteredFormation++;
                }
            } else {
                enteredFormation++;
            }
            if( spr->pos.y < y ) {
                spr->pos.y += 3;
                if( spr->pos.y > y ) {
                    spr->pos.y = y;
                    enteredFormation++;
                }
            } else if( spr->pos.y > y ) {
                spr->pos.y -= 3;
                if( spr->pos.y < y ) {
                    spr->pos.y = y;
                    enteredFormation++;
                }
            } else {
                enteredFormation++;
            }
            break;


        case SPRITE_FORMATION:
            spr->pos.x = formationX + GAME_X + spr->id * (ASSUMED_SPRITE_W) + ASSUMED_SPRITE_W/2;
            spr->pos.y = formationY + spr->line * 70 + 100;

            if( formationY > 8 && attackingFishs < 1 &&  (rand() % 20) < 2 ) {
                sendSpriteOnMove(spr, hero.x+35, hero.y+20);
                spr->state = SPRITE_ATTACK;             
                attackingFishs++;
            }

            break;

        case SPRITE_HIT:
            calcRotation(&(spr->center), spr->curAngle, spr->r, &(spr->pos));
            spr->curAngle-=2;
            spr->r +=8;

            if( spr->pos.x+spr->w < GAME_X-24 || spr->pos.y + spr->h < -24 || spr->pos.x > GAME_END+24 || spr->pos.y > HEIGHT+24 ) {
                spr->state = SPRITE_DEAD;
            }
            break;

        case SPRITE_ATTACK:
        case SPRITE_STATE_STRAIGHT_MOVE:
            spr->fx = spr->fx + spr->dx;
            spr->fy = spr->fy + spr->dy;

            spr->pos.x = (int) spr->fx;
            spr->pos.y = (int) spr->fy;

            if( spr->dx > 0 ) {
                if( spr->dy > 0 ) {
                    if( spr->pos.x >= spr->center.x && spr->pos.y >= spr->center.y ) {
                        spr->state = (spr->state == SPRITE_ATTACK) ? SPRITE_ENTER_FORMATION : SPRITE_STATE_FETCH_MOVE;                      
                        spr->pos.x = spr->center.x;
                        spr->pos.y = spr->center.y;
                    }
                } else {
                    if( spr->pos.x >= spr->center.x && spr->pos.y <= spr->center.y ) {
                        spr->state = (spr->state == SPRITE_ATTACK) ? SPRITE_ENTER_FORMATION : SPRITE_STATE_FETCH_MOVE;                      
                        spr->pos.x = spr->center.x;
                        spr->pos.y = spr->center.y;
                    }
                }
            } else {
                if( spr->dy > 0 ) {
                    if( spr->pos.x <= spr->center.x && spr->pos.y >= spr->center.y ) {
                        spr->state = (spr->state == SPRITE_ATTACK) ? SPRITE_ENTER_FORMATION : SPRITE_STATE_FETCH_MOVE;                      
                        spr->pos.x = spr->center.x;
                        spr->pos.y = spr->center.y;
                    }
                } else {
                    if( spr->pos.x <= spr->center.x && spr->pos.y <= spr->center.y ) {
                        spr->state = (spr->state == SPRITE_ATTACK) ? SPRITE_ENTER_FORMATION : SPRITE_STATE_FETCH_MOVE;                  
                        spr->pos.x = spr->center.x;
                        spr->pos.y = spr->center.y;
                    }
                }

            }            
            break;

        case SPRITE_STATE_FETCH_MOVE:
            switch( *spr->code++ ) {
                case START:
                    //fprintf(f, "%4i  :", (int) spr->code);
                    spr->pos.x = *spr->code++;                  
                    spr->pos.y = *spr->code++;                          

                    //fprintf(f, "Start at: %i, %i\n", spr->pos.x, spr->pos.y);
                    break;

                case FLY_TO:
                    //fprintf(f, "%4i  :", (int) spr->code);
                    x = *spr->code++;
                    y = *spr->code++;
                    sendSpriteOnMove(spr, x,y);
                    //fprintf(f, "Fly to: %i, %i\n", spr->center.x, spr->center.y);
                    break;

                case CIRCLE_AROUND:                    
                    //fprintf(f, "%4i  :", (int) spr->code);
                    x = *spr->code++;
                    y = *spr->code++;
                    r = *spr->code++;
                    sa= *spr->code++;
                    ea= *spr->code++;
                    sendSpriteIntoLoop(spr, 
                                       x, y, 
                                       r,
                                       sa,ea);
                    //fprintf(f, "Rotate around (%i, %i) radius: %i,  start:%i, end:%i\n", spr->center.x, spr->center.y, spr->r, spr->curAngle, spr->destAngle);
                    break;

                case ENTER_FORMATION:
                    spr->state = SPRITE_ENTER_FORMATION;
                    break;

                default:
                    spr->state = -1;

            }
            break;
    }
    //fclose(f);

    if( spr->lastState == SPRITE_ATTACK && spr->state != SPRITE_ATTACK ) {
        attackingFishs = MAX(attackingFishs-1, 0);

    }

    if( enteredFormation == 2 ) {
        if( spr->state == SPRITE_ENTER_FORMATION ) {
            spr->state = SPRITE_FORMATION;
            return 1;
        }
    }
    return justHit;
}

Sprite *createSprite(BITMAP* image, int frameWidth, int* code) {
    Sprite* spr = calloc(1, sizeof(Sprite));
    spr->image  = image;    
    spr->w      = (frameWidth == -1) ? image->w : frameWidth;
    spr->h      = image->h;

    spr->code   = code;
    spr->state  = SPRITE_STATE_FETCH_MOVE;

    handleSprite(spr);

    return spr;
}


void paintText(BITMAP *dest, int x, int y, char* string) {
    int  len     = strlen(string);
    int  index   = 0;
    char curChar    = '\0';
    int  found   = 0;
    int  fontX   = 0;
    int  fontY   = 0;
    int  fontW   = 0;
    int  fontH   = 20;

    //FILE *f = fopen("debug.txt", "w");

    for( index = 0; index < len; index++ ) {
        curChar = *string;


        found =  ((int) strchr(FONT_CHARS, curChar)) - ((int) FONT_CHARS);
        //fprintf(f,"%c : %i  (%c)\n", curChar, found, (found >=0) ? FONT_CHARS[found] : '~');
        if( found >= 0 ) {
            if( found < 18 ) {
                // first line
                fontY = 0;
            } else if( found < 28 ) {
                found++;
                // 2nd line
                fontY = 20;
            } else {
                found+=2;
                // 3rd line
                fontY   = 40;
            }
            fontX = FONT_OFFSETS[found];
            fontW = FONT_OFFSETS[found+1] - fontX;
            //fprintf(f, "fontX: %i   fontW: %i  fontY: %i\n", fontX, fontW, fontY);
            masked_blit(fontImg, dest, fontX, fontY, x, y, fontW, fontH);
            x+=fontW;
        } else {
            x+=10;
        }

        string++;
    }
    //fclose(f);
}

int textLength(char* string) {
    int  len     = strlen(string);
    int  index   = 0;
    char curChar    = '\0';
    int  found   = 0;   
    int  fontW   = 0;   


    for( index = 0; index < len; index++ ) {
        curChar = *string;
        found =  ((int) strchr(FONT_CHARS, curChar)) - ((int) FONT_CHARS);

        if( found >= 0 ) {
            if( found < 18 ) {
            } else if( found < 28 ) {
                found++;
            } else {
                found+=2;
            }           
            fontW += FONT_OFFSETS[found+1] - FONT_OFFSETS[found];           
        } else {
            fontW +=10;
        }

        string++;
    }
    return fontW;
}


void paintTextf(BITMAP *bmp,  int x, int y, AL_CONST char *format, ...) {
    static char buf[512];

    va_list ap;
    va_start(ap, format);
    uvsprintf(buf, format, ap);
    va_end(ap);

    paintText(bmp, x, y, buf);
}

void paintTextfCenter(BITMAP *bmp,  int x, int y, AL_CONST char *format, ...) {
    static char buf[512];
    int         len=0;     

    va_list ap;
    va_start(ap, format);
    uvsprintf(buf, format, ap);
    va_end(ap);

    len = textLength(buf);

    paintText(bmp, x - len/2, y, buf);
}



void rotate_scaled_sprite_c(BITMAP *doubleBuffer, BITMAP* sprite, int x, int y, int angle, int scale) {

    x = x - fixtoi((sprite->w * scale) / 2);
    y = y - fixtoi((sprite->h * scale) / 2);

    rotate_scaled_sprite(doubleBuffer, sprite, x, y, angle, scale);
}


void drawBubbles(BITMAP* dest) {
    int curBubble;
    for( curBubble=0; curBubble < 10; curBubble++ ) {
        masked_blit(bubble, dest, 0, 0, bubbles[curBubble].x, bubbles[curBubble].y, bubble->w, bubble->h);

        bubbles[curBubble].y += bubbleSpeed[curBubble];
        if( bubbles[curBubble].y < -bubble->h ) {
            bubbles[curBubble].x = (rand()% GAME_W)+ GAME_X;
            bubbles[curBubble].y = HEIGHT + (rand()% 40);

            bubbleSpeed[curBubble] = -1 - (rand()%4);
        }
    }
}


int gameLoop(void) {

    int   w,w2,frame;
    int   a, i, x,y, startWave, curWave,dir,amp,counter;    
    Point *pos;
    int   running;
    int   heroSwap = 0;
    int   createSpriteCounter = 0;

    int   level     = 0;
    int   waveOfs   = waveOffset[0];
    int   curWaveId = 0;
    int   waveOfLevel = 0;
    WaveData* curWaveData;

    int   spritesAlive  = 0;
    int   spritesFlying = 0;

    int   moveLeft      = 1;

    int   sprAnimTimeOut = 0;

    int   arrowCount = 0;
    int   arrowsMax  = 6;
    Arrow *firstArrow = NULL;
    Arrow *curArrow   = NULL;
    Arrow *tmp;

    int arrowFired  = 0;
    int spritesToGo = 10;
    int lastTime    = 0;        
    int nextLevel   = 0;
    int levelYDelta = 2;

    int lifes       = 3;
    int score       = 0;

    int hitCounter  = 0;
    int blink       = 0;

    int levelStartTime = 0;
    int skipCounter = 0;
    int needsRepaint = 0;


    Sprite* curSprite  = NULL;
    Sprite* headSprite = NULL;
    Sprite* tmpSprite  = NULL;

    for( a=0; a < WAVE_GROUP_COUNT; a++ ) {
        waveList[a].attackerCountCur = waveList[a].attackerCount;
    }

    clear(doubleBuffer);
    clear_keybuf();

    hero.x = GAME_X + (GAME_W - mermaid->w) / 2;
    hero.y = HEIGHT - mermaid->h -4;

    w = 1;
    w2 = 0;
    startWave = 0;

    dir = 1;
    amp = 5;
    counter=0;

    running = 1;
    frame = 0;



    FMUSIC_SetMasterVolume(gameMusic, 255);
    FMUSIC_PlaySong(gameMusic);

    createSpriteCounter = timerCounter + waveTimerList[curWaveId*3]; 

    formationX = 0;
    formationY = 0;


    levelStartTime = timerCounter;
    attackingFishs = 0;

    fpsCounter = 0;
    while( running ) {
        if( key[KEY_ESC] ) {
            running = 0;
            break;
        }
        skipCounter = 0;

        if( fpsCounter > 0 ) {
            while( fpsCounter > 0 ) {

                curSprite = headSprite;
                while( curSprite != NULL ) {
                    if( handleSprite(curSprite) ) {
                        spritesFlying--;

                        if( spritesFlying <= 0 ) {
                            curWaveId++;

                            if( curWaveId < waveCount[level] ) {
                                createSpriteCounter = timerCounter + waveTimerList[curWaveId*3];
                            }
                        }
                    }
                    //drawSprite(curSprite, doubleBuffer);

                    pos = &curSprite->pos;
                    if( curSprite->state < SPRITE_HIT &&
                        hitCounter < timerCounter &&                
                        pos->x -24 < hero.x +  50 && 
                        pos->x +24 > hero.x +  20 && 
                        pos->y -24 < hero.y + 160 && 
                        pos->y +24 > hero.y ) {

                        lifes--;
                        formationY /= 2;

                        curSprite = headSprite;
                        while( curSprite != NULL ) {
                            if( curSprite->state < SPRITE_HIT ) {
                                curSprite->state = SPRITE_ENTER_FORMATION;
                            }
                            curSprite = curSprite->next;
                        }
                        hitCounter = timerCounter+200;


                        FSOUND_PlaySound(FSOUND_FREE, hurt);
                        if( lifes  <= 0 ) {
                            running = 0;
                        }
                        break;
                    }



                    if( curSprite->state == SPRITE_DEAD ) {

                        if( curSprite->prev != NULL ) {
                            ((Sprite*)curSprite->prev)->next = curSprite->next;
                        } else {
                            headSprite = curSprite->next;
                        }

                        if( curSprite->next != NULL ) {
                            ((Sprite*)curSprite->next)->prev = curSprite->prev;
                        }

                        spritesAlive--;

                        if( spritesAlive == 0 && curWaveId >= waveCount[level] ) {
                            FSOUND_PlaySound(FSOUND_FREE, tataa);
                            nextLevel = timerCounter + 500;

                            levelStartTime = timerCounter - levelStartTime;
                        }


                        tmpSprite = curSprite->next;
                        free(curSprite);
                        curSprite = tmpSprite;
                    } else {
                        curSprite = (Sprite*) curSprite->next;
                    }            
                }

                curArrow = firstArrow;
                while( curArrow != NULL ) {
                    a = handleArrow(doubleBuffer, curArrow, headSprite);
                    if( a > 0 ) {
                        if( curArrow->prev != NULL ) {
                            ((Arrow*)curArrow->prev)->next = curArrow->next;
                        } else {
                            firstArrow = curArrow->next;
                        }
                        if( curArrow->next != NULL ) {
                            ((Arrow*)curArrow->next)->prev = curArrow->prev;
                        }

                        if( a>1 ) {
                            score+=a;
                        }

                        tmp = (Arrow*) curArrow->next;
                        free(curArrow);
                        curArrow = tmp;

                        arrowCount--;
                    } else {
                        curArrow = (Arrow*) curArrow->next;
                    }
                }


                if( sprAnimTimeOut < timerCounter ) {
                    sprAnimTimeOut = timerCounter+12;

                    curFrame++;
                    curFrame%=FRAME_COUNT;
                }



                if( key[KEY_LEFT] ) {
                    hero.x -= 4;
                    heroSwap = 1;
                } else if( key[KEY_RIGHT] ) {
                    hero.x += 4;
                } else if( key[KEY_ESC] ) {
                    running = 0;
                }

                hero.x = MID(GAME_X - 32, hero.x, END_X + 32);

                if( key[KEY_SPACE] ) {
                    if( !arrowFired ) {
                        arrowFired = 1;
                        if( arrowCount < arrowsMax ) {
                            curArrow = (Arrow*) calloc(1, sizeof(Arrow));
                            curArrow->x = hero.x + SHOOT_ADJUST_X;
                            curArrow->y = hero.y + SHOOT_ADJUST_Y;
                            curArrow->next = firstArrow;

                            if( firstArrow != NULL ) {
                                firstArrow->prev = curArrow;
                            }

                            firstArrow = curArrow;
                            arrowCount++;

                            FSOUND_PlaySound(FSOUND_FREE, shoot);
                        }
                    }
                } else {
                    arrowFired = 0;
                }




                //masked_blit(mermaid, doubleBuffer, frame*70, 0, hero.x, hero.y, 70, mermaid->h);



                if( moveLeft ) {
                    formationX+=2;
                    if( formationX > 50 ) {
                        moveLeft = 0;
                        formationX = 50;

                        if( spritesAlive > 0 && spritesFlying <= 0 ) {
                            formationY+=levelYDelta;
                        }
                    }
                } else {
                    formationX-=2;
                    if( formationX < 0 ) {
                        moveLeft = 1;
                        formationX = 0;
                        if( spritesAlive > 0 && spritesFlying <= 0 ) {
                            formationY+=levelYDelta;
                        }
                    }
                }



                // CurWaveId holds the current wave index
                // waveTimerList holds start times, the number of individual groups and the
                // index of the groups into the waveList
                if( createSpriteCounter < timerCounter && curWaveId < waveCount[level] ) {
                    i= waveOfs + curWaveId*3;
                    for( a=0; a < waveTimerList[i +1]; a++ ) {
                        curWaveData = &(waveList[waveTimerList[i +2]+a]);
                        spritesToGo = curWaveData->attackerCountCur;

                        if( spritesToGo > 0 ) {
                            curSprite  = createSprite(enemy[curWaveData->attackerType], 48, curWaveData->path);                 

                            curSprite->id   = spritesToGo-1;
                            curSprite->line = curWaveData->targetLine;

                            if( headSprite != NULL ) {
                                curSprite->next = headSprite;               
                                headSprite->prev = curSprite;
                            }

                            curSprite->next  = headSprite;
                            headSprite       = curSprite;
                            curWaveData->attackerCountCur--;                    

                            spritesAlive++;
                            spritesFlying++;

                            createSpriteCounter = timerCounter+20;
                        }
                    }           
                }
                fpsCounter--;
                skipCounter++;
                if( skipCounter >= 4 ) {
                    fpsCounter = 0;
                }
            }
            needsRepaint = 1;
        }
        if( needsRepaint ) {
            needsRepaint = 0;

            clear(doubleBuffer);
            blit(bg, doubleBuffer, 0, 0, GAME_X, 0, GAME_W, HEIGHT);
            curSprite = headSprite;
            while( curSprite != NULL ) {
                drawSprite(curSprite, doubleBuffer);
                curSprite = (Sprite*) curSprite->next;
            }
            curArrow = firstArrow;
            while( curArrow != NULL ) {
                masked_blit(arrow, doubleBuffer ,0,0,curArrow->x, curArrow->y, arrow->w, arrow->h);
                curArrow = (Arrow*) curArrow->next;
            }

            if( nextLevel != 0 ) {
                masked_blit(wellDone, doubleBuffer, 0, 0, (WIDTH-wellDone->w)/2, (HEIGHT-wellDone->h)/2, wellDone->w, wellDone->h);


                paintTextfCenter(doubleBuffer, CENTER_X, CENTER_Y + wellDone->h+10, "TIME BONUS: %i", MAX((3000 + 800*level) - levelStartTime,0));

                if( timerCounter > nextLevel ) {
                    nextLevel = 0;
                    level++;
                    if( level >= LEVEL_COUNT ) {
                        for( a=0; a < WAVE_GROUP_COUNT; a++ ) {
                            waveList[a].attackerCountCur = waveList[a].attackerCount;
                        }
                        level = 0;
                    }
                    score      += MAX((3000 + 800*level) - levelStartTime,0);
                    waveOfs    =  waveOffset[level];
                    curWaveId  = 0;
                    formationY = 0;
                    spritesFlying = 0;

                    levelYDelta++;

                    levelStartTime = timerCounter;

                }
            }
            if( hitCounter > timerCounter ) {
                if( blink ) {
                    blink=0;
                    masked_blit(mermaid, doubleBuffer, 0, 0, hero.x, hero.y, 70, mermaid->h);
                } else {
                    blink = 1;
                }
            } else {
                masked_blit(mermaid, doubleBuffer, 0, 0, hero.x, hero.y, 70, mermaid->h);
            }


            
            paintTextf(doubleBuffer, GAME_X+10, 20, "SCORE: %i", score);

            for( a=0, x = END_X-smallMermaid->w; a < lifes; a++, x-= (smallMermaid->w+10) ) {
                masked_blit(smallMermaid, doubleBuffer, 0, 0, x, 0, smallMermaid->w, smallMermaid->h);
            }

            startWave++;
            startWave &= 0xff;      

            curWave = startWave;
            for( y=0; y < SCREEN_H; y++ ) {
                curWave ++;
                curWave &= 0xff;
                //hline(screen,GAME_X,y, GAME_X+bg->w+waveTable[curWave]*2,0);
                blit(doubleBuffer, screen, GAME_X-waveTable[curWave], y, GAME_X,y, doubleBuffer->w - GAME_X, 1);
            }

        }
    }
    FMUSIC_StopSong(gameMusic);

    return score;
}

int compare(const void* lhs, const void* rhs) {
    return((Hiscore*) rhs)->score - ((Hiscore*) lhs)->score;
}

void hiscore(int score) {

    int a,y;
    int done;
    int enter = 0;
    int position = -1;
    int sel = 0;
    int c   = 28;
    int len = strlen(FONT_CHARS);
    int lastKey = -1;

    FILE *f;

    blit(fxBuffer, doubleBuffer,0, 0, 0, 0, WIDTH, HEIGHT);
    masked_blit(gameOver, doubleBuffer, 0, 0, CENTER_X - gameOver->w/2, 40, gameOver->w, gameOver->h);

    paintTextfCenter(doubleBuffer, CENTER_X, 140, "HIGH SCORES");

    enter = score > hiscores[9].score;  

    strcpy(hiscores[10].name, "~~~");
    hiscores[10].score = score;

    qsort(hiscores, 11, sizeof(Hiscore), compare);

    if( enter ) {
        for( a=0; a < 10; a++ ) {
            if( !strcmp(hiscores[a].name, "~~~") ) {
                hiscores[a].name[0] = FONT_CHARS[c];
                hiscores[a].name[1] = '\0';
                position = a;
                break;
            }
        }
    }

    if( enter ) {
        paintTextfCenter(doubleBuffer, CENTER_X, 180, "PLEASE ENTER YOUR INITIALS");
        paintTextfCenter(doubleBuffer, CENTER_X, 200, "USE CURSOR KEYS TO CHOOSE");
        paintTextfCenter(doubleBuffer, CENTER_X, 220, "PRESS SPACE TO SELECT");
    }




    clear_keybuf();

    done = 0;
    while( !done ) {

        blit(fxBuffer, doubleBuffer, 0, 270, 0, 270, WIDTH, HEIGHT-270);

        if( key[KEY_ESC] ) {
            done = 1;
        } else if( key[KEY_UP] ) {

            if( lastKey != KEY_UP ) {
                lastKey = KEY_UP;
                c++;
                c%=len;

                hiscores[position].name[sel] = FONT_CHARS[c];
            }
        } else if( key[KEY_DOWN] ) {
            if( lastKey != KEY_DOWN ) {
                lastKey = KEY_DOWN;
                c--;
                if( c <0 ) {
                    c = len-1;
                }

                hiscores[position].name[sel] = FONT_CHARS[c];
            }
        } else if( key[KEY_SPACE] ) {
            if( lastKey != KEY_SPACE ) {
                lastKey = KEY_SPACE;
                sel++;
                if( sel>=3 ) {
                    done = 1;
                    FSOUND_PlaySound(FSOUND_FREE, theEnd);
                    rest(1500);
                } else {
                    c = 28;
                    hiscores[position].name[sel] = FONT_CHARS[c];
                }
            }
        } else {
            lastKey = 0;
        }

        for( a=0; a < 10; a++ ) {
            y = 270+ 22 * a;

            if( a == position ) {
                paintText(doubleBuffer, GAME_X +  20, y+4, "*");
                paintText(doubleBuffer, END_X  -  30, y+4, "*");
            }

            paintTextf(doubleBuffer, GAME_X +  40, y, "%2i", a+1);
            paintText (doubleBuffer, GAME_X +  65, y, ")");
            paintTextf(doubleBuffer, GAME_X + 155, y, "%s" , hiscores[a].name);
            paintTextf(doubleBuffer, GAME_X + 255, y, "%8i", hiscores[a].score);
        }

        blit(doubleBuffer, screen, 0, 0, 0, 0, WIDTH, HEIGHT);



    }
    if( key[KEY_ESC] ) {
        while( key[KEY_ESC] ) {
        }
    }

    f= fopen("highscore.inf", "wb");
    fwrite(hiscores, sizeof(Hiscore), 10, f);
    fclose(f);

    clear_keybuf();
}

int main(int argc, char **argv) {

    Point pos;
    Point center;
    int angle;
    int x, len;

    int goOn  = 1;
    int menu  = 1;
    int score = 0;
    int needsRepaint = 0;

    center.x = WIDTH /2;
    center.y = HEIGHT/2;


    firstTimeInit();
    loadImages();
    loadSounds();   

    clear(screen);
    clear(doubleBuffer);
    angle=0;
    set_clip(doubleBuffer, GAME_X, 0, GAME_X+GAME_W, HEIGHT);

    len = textLength(GREETINGS);

    while( goOn ) {
        menu = 1;
        clear_keybuf();

        x = END_X + 10;

        FMUSIC_PlaySong(titleMusic);

        fpsCounter=0;
        while( menu ) {
            //clear(doubleBuffer);

            if(fpsCounter) {
                while(fpsCounter) {
                    angle++;
                    calcRotation(&center, angle, 40, &pos);
                    pos.x -= WIDTH/2;
                    pos.y -= HEIGHT/2+50;
                    x-=2;

                    if( x + len < GAME_X -10 ) {
                        x = END_X +10;
                    }
                    --fpsCounter;
                }
                needsRepaint=1;
            }


            if( key[KEY_SPACE] ) {
                menu = 0;
            } else if( key[KEY_ESC] ) {
                menu = 0;
                goOn = 0;
            }

            if(needsRepaint) {
                needsRepaint=0;
                blit(title, doubleBuffer, 0, 0, GAME_X, 0, GAME_W, HEIGHT);
                drawBubbles(doubleBuffer);
                draw_trans_sprite(doubleBuffer, fxBuffer, pos.x, pos.y);
                paintText(doubleBuffer, x, HEIGHT-25, GREETINGS);
                blit(doubleBuffer, screen, GAME_X, 0, GAME_X, 0, GAME_W, HEIGHT);
            }
            
        }
        if( goOn ) {
            FMUSIC_StopSong(titleMusic);            
            score = gameLoop();         
            FSOUND_PlaySound(FSOUND_FREE, theEnd);
            hiscore(score);         
        }
    }

    //animateDoor(title, TRUE);

    rest(1000);


    FMUSIC_FreeSong(gameMusic);
    FMUSIC_FreeSong(titleMusic);
    FSOUND_Close();

    return 0;
} 
END_OF_MAIN();
