#include "global.h"
void lockon()
{
	/*uses feedback to test where badguys are relative to
	the screen if the targetting is on and the badguy is
	close to the center of the screen for about 1/2 a second
	the badguy will be locked in the target. A sphere will
	appear around the badguy to show that it is locked also
	the badguy will be viewed in the center of the screen
	Also when the player moves the player will straf in a 
	radius around the badguy.*/
GLfloat feedBuffer[1024];
GLint size; /*size of points recorded in feedback buffer*/
GLint count; 

GLint pass;
GLfloat centering_hold=0;

GLfloat centering=100000;

/*if no objects are locked in the feed back buffer is checked*/
if(object_locked==OFF)
{
glFeedbackBuffer(1024,GL_3D,feedBuffer);
(void) glRenderMode(GL_FEEDBACK);
/*adds the wolf to the feedback buffer
if the wolf is still alive*/
if(wolf.alive==ON)
{
glPassThrough(1.0);

glBegin(GL_POINTS);
glVertex3f(wolf.pos.x,wolf.pos.y,wolf.pos.z);
glEnd();
}
/*adds the gyro to the feedback buffer
if the gyro is still alive*/
if(gyro.alive==ON)
{
glPassThrough(2.0);

glBegin(GL_POINTS);
glVertex3f(gyro.pos.x,gyro.pos.y,gyro.pos.z);
glEnd();
}
size = glRenderMode(GL_RENDER); /*returns amount of data recorded*/
memset(locked,0,sizeof(struct VECTOR)*99);/*clears the locked 
										  Vector this array records
										  the data sent to the
										  feedback buffer*/
/*for loop does a loop for every entry recorded*/
for(count=0;count<size;count++)
{
pass=feedBuffer[count]; 
/*checks if it is at a GL_PASS_THROUGH_TOKEN*/
if(pass==GL_PASS_THROUGH_TOKEN)
{
pass=feedBuffer[count+1];
/*makes sure that an entry was recorded for that token*/
if(feedBuffer[count+2]!=GL_PASS_THROUGH_TOKEN&& count+4<size)
{
/*records the position recorded and zeros that position to
the center of the screen*/
locked[pass].x=SCREEN_W/2-feedBuffer[count+3];
locked[pass].y=SCREEN_H/2-feedBuffer[count+4];
locked[pass].z=feedBuffer[count+5];
/*totals the distance from the center of the screen
using hypotenus*/
centering_hold=sqrt(locked[pass].x*locked[pass].x+locked[pass].y*locked[pass].y);


/*if there is no other objects on the screen
already recorded as being closer to the center of the screen*/

if(centering>centering_hold)
{
centering=centering_hold;
/*makes sure that the badguy is close to the center
of the screen for 0.75 seconds*/
if(centering<100&&lockon_timer>750)
{
	object_locked=pass; /*records what badguy was found
						to be close to the center of the screen*/
	do_lockon_timer=OFF;
}

}

}

}
}
/*show_cross_hair tells what color to draw
the crosshairs red if it is close to an object
green if it is further from an object*/
show_cross_hair=centering;
/*as long as the closest object is found close
to the center the timer is enabled*/
if(centering<100)do_lockon_timer=ON;
else
do_lockon_timer=OFF;
}
/*if an object is locked these if statement will
tell what badguy it is*/
if(object_locked==1)
{
locked[0].x=wolf.pos.x;
locked[0].y=wolf.pos.y+7;
locked[0].z=wolf.pos.z;
/*draws a sphere around the wolf*/
draw_target_sphere(wolf.pos.x,wolf.pos.y, wolf.pos.z, 25,wolf.energy,wolf.energy_max);

}
if(object_locked==2)
{
locked[0].x=gyro.pos.x;
locked[0].y=gyro.pos.y+5;
locked[0].z=gyro.pos.z;
/*draws a sphere around the gyro*/
draw_target_sphere(gyro.pos.x,gyro.pos.y, gyro.pos.z, 85,gyro.energy,gyro.energy_max);

}



  }
