#include "global.h"


int InsidePolygon(VECTOR *polygon,int npol,VECTOR pt)
{

/*this function tests if the point is within the polygon.
this function is called if the point to the surface of the
polygon distance is found to be in tolerance
	
it works by checking if the point crosses the plane a even
or a odd number of times. If it returns a even number
the point is not within the polygon*/
	int	i, j, c = 0;

VECTOR vlist[4];

VECTOR p;

	if((fabs(Ntest_v.x) >= fabs(Ntest_v.y)) && (fabs(Ntest_v.x) >= fabs(Ntest_v.z)))
	{// flatten in yz plane
		for(i=0; i<4; i++)
		{
			vlist[i].x = polygon[i].y;	
			vlist[i].y = polygon[i].z;	
			vlist[i].z = 0.0f;
		}
		p.x = pt.y;
		p.y = pt.z;
		p.z = 0.0;

		
	} else if((fabs(Ntest_v.y) >= fabs(Ntest_v.x)) && (fabs(Ntest_v.y) >= fabs(Ntest_v.z)))
	{// flatten in xz plane
		for(i=0; i<4; i++)
		{
			vlist[i].x = polygon[i].x;	
			vlist[i].y = polygon[i].z;	
			vlist[i].z = 0.0f;
		}
		p.x = pt.x;
		p.y = pt.z;
		p.z = 0.0;

		
	} else if((fabs(Ntest_v.z) >= fabs(Ntest_v.x)) && (fabs(Ntest_v.z) >= fabs(Ntest_v.y)))
	{// flatten in xy plane
		for(i=0; i<4; i++)
		{
			vlist[i].x = polygon[i].x;	
			vlist[i].y = polygon[i].y;	
			vlist[i].z = 0.0f;
		}
		p.x = pt.x;
		p.y = pt.y;
		p.z = 0.0;

		
	}





	for (i = 0, j = npol-1; i<npol; j = i++) {
		if ((((vlist[i].y<=p.y) && (p.y<vlist[j].y)) ||
			 ((vlist[j].y<=p.y) && (p.y<vlist[i].y))) &&
			(p.x < (vlist[j].x - vlist[i].x) * (p.y - vlist[i].y) / (vlist[j].y - vlist[i].y) + vlist[i].x))

		   c = !c;
	}
	return c;


}