// thematrixeatsyou@yahoo.co.nz - created 2005

#include <stdio.h>
#include <time.h>

#include <allegro.h>
#include <winalleg.h>

typedef struct {
    int n,e,s,w;
    int flags;
    int prevx,prevy;
} maze_bits;

#define MAX_MAZE_W 512
#define MAX_MAZE_H 512

int maze_w;
int maze_h;
int bx_start;
int by_start;
int draw_delay;

//#define NO_DRAW 1
//#define NO_SAVE 1
#define LIVE 1
// KEEP NO_WRAP ON 1! MAZE WRAPPING DOESN'T WORK YET!
#define NO_WRAP 1
//#define DEBUG 1
#define EDITMODE 1

#define gm_quit 0
#define gm_play 1
#define gm_edit 2
int gamemode;

char fname[512];

maze_bits maze[MAX_MAZE_W][MAX_MAZE_H];
maze_bits blank;
int bx,by,bl,px,py;
//int bx2,by2,bl2,px2,py2;
int maxx,maxy,maxl;
int camx,camy,pcamx,pcamy;
int drawlay;
int movticks;

int unedited;
int emode,estage;
#define em_null 0
#define em_box 1
#define em_erase 2
#define em_redraw 3

BITMAP *blah,*mazeb;
BITMAP *imported;
char gfximport[16][512];

/// Functions...
int askatoi(char *prompt){
    int result;
    printf(prompt);scanf("%s",fname);
    result=atoi(fname);
    fname[0]="\0";
    return result;
}
int rendersq(int rsqx,int rsqy){
    if(!maze[rsqy][rsqx].n) line(mazeb,
    rsqx*8,rsqy*8,rsqx*8+7,rsqy*8,makecol(0,0,0));
    if(!maze[rsqy][rsqx].e) line(mazeb,
    rsqx*8+7,rsqy*8,rsqx*8+7,rsqy*8+7,makecol(0,0,0));
    if(!maze[rsqy][rsqx].s) line(mazeb,
    rsqx*8,rsqy*8+7,rsqx*8+7,rsqy*8+7,makecol(0,0,0));
    if(!maze[rsqy][rsqx].w) line(mazeb,
    rsqx*8,rsqy*8,rsqx*8,rsqy*8+7,makecol(0,0,0));
}
#ifndef NO_DRAW
int rendersqeen(int rsqx,int rsqy){
    if(pcamx/8>rsqx | pcamx/8+79<rsqx
    | pcamy/8>rsqy | pcamy/8+59<rsqy){
    return 1;
    }
    
    rectfill(screen,rsqx*8-pcamx,rsqy*8-pcamy,
    rsqx*8+7-pcamx,rsqy*8+7-pcamy,makecol(255,255,255));
    if(!maze[rsqy][rsqx].n) line(screen,
    rsqx*8-pcamx,rsqy*8-pcamy,rsqx*8+7-pcamx,rsqy*8-pcamy,makecol(0,0,0));
    if(!maze[rsqy][rsqx].e) line(screen,
    rsqx*8+7-pcamx,rsqy*8-pcamy,rsqx*8+7-pcamx,rsqy*8+7-pcamy,makecol(0,0,0));
    if(!maze[rsqy][rsqx].s) line(screen,
    rsqx*8-pcamx,rsqy*8+7-pcamy,rsqx*8+7-pcamx,rsqy*8+7-pcamy,makecol(0,0,0));
    if(!maze[rsqy][rsqx].w) line(screen,
    rsqx*8-pcamx,rsqy*8-pcamy,rsqx*8-pcamx,rsqy*8+7-pcamy,makecol(0,0,0));
    #ifdef DEBUG
    if(maze[rsqy][rsqx].prevx<rsqx){
        rectfill(screen,rsqx*8+1-pcamx,rsqy*8+1-pcamy,
        rsqx*8+3-pcamx,rsqy*8+6-pcamy,makecol(255,0,255));
    }
    if(maze[rsqy][rsqx].prevy<rsqy){
        rectfill(screen,rsqx*8+1-pcamx,rsqy*8+1-pcamy,
        rsqx*8+6-pcamx,rsqy*8+3-pcamy,makecol(255,0,255));
    }
    if(maze[rsqy][rsqx].prevx>rsqx){
        rectfill(screen,rsqx*8+4-pcamx,rsqy*8+1-pcamy,
        rsqx*8+6-pcamx,rsqy*8+6-pcamy,makecol(255,0,255));
    }
    if(maze[rsqy][rsqx].prevy>rsqy){
        rectfill(screen,rsqx*8+1-pcamx,rsqy*8+4-pcamy,
        rsqx*8+6-pcamx,rsqy*8+6-pcamy,makecol(255,0,255));
    }
    #endif
    return 0;
}
#endif
int drawmaze(int renderall){
    int x,y;
    if(renderall==1){
    clear_bitmap(mazeb);
    rectfill(mazeb,0,0,maze_w*8,maze_h*8,makecol(255,255,255));
    for(y=0;y<maze_h;y++){
    for(x=0;x<maze_w;x++){
        rendersq(x,y);
    }}
    }else{    
        pcamx=camx;pcamy=camy;
    rectfill(mazeb,camx,camy,camx+640,camy+480,makecol(255,255,255));
    for(y=(camy>0?camy/8:0);y<(camy/8<maze_h-30?camy/8+60:maze_h);y++){
    for(x=(camx>0?camx/8:0);x<(camx/8<maze_w-40?camx/8+80:maze_w);x++){
        rendersq(x,y);
    }}
    }
    circlefill(mazeb,bx*8+4,by*8+4,3,makecol(0,255,0));
    circlefill(mazeb,maxx*8+4,maxy*8+4,3,makecol(255,0,0));
}    
int clearmaze(void){
    int cx,cy,ci;
    unedited=1;
    bx=px=bx_start;by=py=by_start;
    bl=maxx=maxy=maxl=0;
    drawlay=draw_delay;
    #ifndef NO_DRAW
    rectfill(screen,0,0,640,480,makecol(255,255,255));
    #endif
    for(cy=0;cy<maze_h;cy++){
    for(cx=0;cx<maze_w;cx++){
        maze[cy][cx]=blank;
    }}
    #ifndef NO_DRAW
    for(ci=0;ci<60;ci++){
        line(screen,0,ci*8,640,ci*8,makecol(0,0,0));
        line(screen,0,ci*8+7,640,ci*8+7,makecol(0,0,0));
    }
    for(ci=0;ci<80;ci++){
        line(screen,ci*8,0,ci*8,480,makecol(0,0,0));
        line(screen,ci*8+7,0,ci*8+7,480,makecol(0,0,0));
    }
    #endif
    maze[by_start][bx_start].prevx=bx_start;
    maze[by_start][bx_start].prevy=by_start;

    camx=camy=pcamx=pcamy=0;
}

/// Code....
int editloop(void){
    int x,y,i;
    if(unedited){
        bx=bx_start;by=by_start;
        if(unedited==1) clearmaze();
        drawmaze(0);
        //blit(mazeb,blah,camx,camy,0,0,640,480);
        if(unedited==1) install_mouse();
        set_window_title(
"daze.maze - advanced dfs maze generator by thematrixeatsyou@yahoo.co.nz");
        unedited=0;
    }
    poll_keyboard();
    poll_mouse();
    blit(mazeb,blah,camx,camy,0,0,640,480);
    circle(blah,mouse_x,mouse_y,3,makecol(0,128,255));
    rectfill(blah,(mouse_x/8)*8+1,(mouse_y/8)*8+1
    ,(mouse_x/8)*8+6,(mouse_y/8)*8+6,makecol(255,255,0));
    
    /// EM_BOX(1)
    if(emode==em_box){
    if(estage==0 & (mouse_b & 1)){
        px=mouse_x/8;py=mouse_y/8;
        estage=1;
        set_window_title("Box edit: Drag");
    }
    if(estage==1){
    bx=mouse_x/8;by=mouse_y/8;
    for(x=px;(px<bx?x<=bx:x>=bx);(px<bx?x++:x--)){ // Ew. Messy code.
    for(y=py;(py<by?y<=by:y>=by);(py<by?y++:y--)){ // But it works very nicely.
        rectfill(blah,x*8+1,y*8+1,x*8+6,y*8+6,makecol(255,255,0));
    }}
    if(!mouse_b & 1){
        estage=2;
        set_window_title("Box edit: Select");
    }}
    if(estage==2){
    for(x=px;(px<bx?x<=bx:x>=bx);(px<bx?x++:x--)){ // Ew. Messy code.
    for(y=py;(py<by?y<=by:y>=by);(py<by?y++:y--)){ // But it works very nicely.
        rectfill(blah,x*8+1,y*8+1,x*8+6,y*8+6,makecol(255,255,0));
    }}
    }}
    /// EM_ERASE(2)
    if(emode==em_erase){
    if(estage==0 & (mouse_b & 1)){
        estage=1;
        set_window_title("Eraser: Drag");
        px=mouse_x/8;py=mouse_y/8;
    }if(estage==1){
        bx=mouse_x/8;by=mouse_y/8;
        maze[by][bx].n=1;
        maze[by][bx].e=1;
        maze[by][bx].s=1;
        maze[by][bx].w=1;
        maze[by][bx].flags=1;
        rectfill(blah,bx*8,by*8,bx*8+7,by*8+7,makecol(255,255,255));
        rectfill(blah,px*8,py*8,px*8+7,py*8+7,makecol(255,255,255));
        rectfill(mazeb,bx*8,by*8,bx*8+7,by*8+7,makecol(255,255,255));
        rectfill(mazeb,px*8,py*8,px*8+7,py*8+7,makecol(255,255,255));

        px=bx;py=by;
        if(!mouse_b & 1){
            estage=0;emode=0;unedited=2;
        }
    }
    }
    /// EM_REDRAW(3)
    if(emode==em_redraw){
    if(estage==0 & (mouse_b & 1)){
        estage=1;
        set_window_title("Redraw: Drag");
        px=mouse_x/8;py=mouse_y/8;
    }if(estage==1){
        bx=mouse_x/8;by=mouse_y/8;
        maze[by][bx].n=0;
        maze[by][bx].e=0;
        maze[by][bx].s=0;
        maze[by][bx].w=0;
        maze[by][bx].flags=0;
        rect(blah,bx*8,by*8,bx*8+7,by*8+7,makecol(0,0,0));
        rect(blah,px*8,py*8,px*8+7,py*8+7,makecol(0,0,0));
        rect(mazeb,bx*8,by*8,bx*8+7,by*8+7,makecol(0,0,0));
        rect(mazeb,px*8,py*8,px*8+7,py*8+7,makecol(0,0,0));

        px=bx;py=by;
        if(!mouse_b & 1){
            estage=0;emode=0;unedited=2;
        }
    }
    }
    
    blit(blah,screen,0,0,0,0,640,480);
    
    /// KBD
    if(emode==1 && estage==2){
    if(key[KEY_DEL]){
        // Copy-paste job, *sigh*. But that shows that it works, doesn't it?
    for(x=px;(px<bx?x<=bx:x>=bx);(px<bx?x++:x--)){ // Ew. Messy code.
    for(y=py;(py<by?y<=by:y>=by);(py<by?y++:y--)){ // But it works very nicely.
        maze[y][x].n=1;
        maze[y][x].e=1;
        maze[y][x].s=1;
        maze[y][x].w=1;
        maze[y][x].flags=1;
    }}
        emode=0;estage=0;unedited=2;
    }if(key[KEY_INSERT]){
        // Copy-paste job, *sigh*. But that shows that it works, doesn't it?
    for(x=px;(px<bx?x<=bx:x>=bx);(px<bx?x++:x--)){ // Ew. Messy code.
    for(y=py;(py<by?y<=by:y>=by);(py<by?y++:y--)){ // But it works very nicely.
        maze[y][x].n=0;
        maze[y][x].e=0;
        maze[y][x].s=0;
        maze[y][x].w=0;
        maze[y][x].flags=0;
    }}
        emode=0;estage=0;unedited=2;
    }
    }
    if(key[KEY_B]){
        set_window_title("Box edit");
        emode=em_box;estage=0;
    }
    if(key[KEY_E]){
        set_window_title("Eraser");
        emode=em_erase;estage=0;
    }
    if(key[KEY_D]){
        set_window_title("Redraw");
        emode=em_redraw;estage=0;
    }
    if(key[KEY_LCONTROL] & key[KEY_P]){
        bx=px=bx_start;by=py=by_start;
        gamemode=gm_play;
    }
}
/// Code....

int gameloop(void){
    int x,y,i;
    srand(clock()+movticks);
    movticks+=rand()%3+1;
    
    if(maze_w>80){
    if(bx<40){
        camx=0;
    }else if(bx>maze_w-40){
        camx=maze_w*8-640;
    }else{
        camx=bx*8-320;
    }}
    
    if(maze_h>60){
    if(by<30){
        camy=0;
    }else if(by>maze_h-30){
        camy=maze_h*8-480;
    }else{
        camy=by*8-240;
    }}
    
    #ifndef LIVE
    if(drawlay<0 & (maze_w>80 | maze_h>60)){
    
    #ifndef NO_DRAW
    drawmaze(0);
    blit(mazeb,screen,camx,camy,0,0,640,480);
    /*textprintf(blah,font,640,0,makecol(0,255,0),"Your pos:");
    textprintf(blah,font,640,8,makecol(0,255,0),"%i,%i",bx,by);
    textprintf(blah,font,640,16,makecol(0,255,0),"Your previous:");
    textprintf(blah,font,640,24,makecol(0,255,0),"%i,%i",px,py);
    textprintf(blah,font,640,32,makecol(0,255,0),"Maze.previous:");
    textprintf(blah,font,640,40,makecol(0,255,0),"%i,%i"
    ,maze[by][bx].prevx,maze[by][bx].prevy);//*/   
    
    #endif
    drawlay=draw_delay;
    pcamx=camx;pcamy=camy;
    }
    drawlay--;
    #endif
    i=rand()%4;
    if((bx>0 | !NO_WRAP) & !(maze[by][bx-1].flags & 1) & i==0){
        maze[by][bx].w=1;
        maze[by][bx].flags=1;
        #ifndef NO_DRAW
        rendersqeen(bx,by);
        #endif
        bx--;
        if(!NO_WRAP & bx<0){bx+=maze_w;}
        maze[by][bx].e=1;
    }else if(i==0) i++;
    if((by>0 | !NO_WRAP) & !(maze[by-1][bx].flags & 1) & i==1){
        maze[by][bx].n=1;
        maze[by][bx].flags=1;
        #ifndef NO_DRAW
        rendersqeen(bx,by);
        #endif
        by--;
        if(!NO_WRAP & by<0){by+=maze_h;}
        maze[by][bx].s=1;
    }else if(i==1) i++;
    if((bx<maze_w-1 | !NO_WRAP) & !(maze[by][bx+1].flags & 1) & i==2){
        maze[by][bx].e=1;
        maze[by][bx].flags=1;
        #ifndef NO_DRAW
        rendersqeen(bx,by);
        #endif
        bx++;
        if(!NO_WRAP & bx>=maze_w){bx-=maze_w;}
        maze[by][bx].w=1;
    }else if(i==2) i++;
    if((by<maze_h-1 | !NO_WRAP) & !(maze[by+1][bx].flags & 1) & i==3){
        maze[by][bx].s=1;
        maze[by][bx].flags=1;
        #ifndef NO_DRAW
        rendersqeen(bx,by);
        #endif
        by++;
        if(!NO_WRAP & by>=maze_h){by-=maze_h;}
        maze[by][bx].n=1;
    }
    if(bx!=px | by!=py){
        if(!NO_WRAP){
            if(bx<0){bx+=maze_w;}
            if(by<0){by-=maze_h;}
            if(bx>=maze_w){bx-=maze_w;}
            if(by>=maze_h){by-=maze_h;}
        }
        #ifndef NO_DRAW
        rendersqeen(bx,by);
        circlefill(screen,bx*8+4-pcamx,by*8+4-pcamy,3,makecol(0,255,0));
        circlefill(screen,maxx*8+4-pcamx,maxy*8+4-pcamy,3,makecol(255,0,0));
        #endif
        maze[by][bx].prevx=px;
        maze[by][bx].prevy=py;
        bl++;
        if(bx>pcamx/8+80 | bx<pcamx/8 |
           by>pcamy/8+60 | by<pcamy/8){
        //if(camx!=pcamx | camy!=pcamy){
             #ifndef NO_DRAW
             #ifdef LIVE
             drawlay--;
             if(drawlay<0){
             pcamx=camx;pcamy=camy;
             drawlay=draw_delay;
             drawmaze(0);
             blit(mazeb,screen,camx,camy,0,0,640,480);
             }
             #endif
             #endif
        }else{
             drawlay=draw_delay;
        }
        if(bl>maxl){
            #ifndef NO_DRAW
            rendersqeen(maxx,maxy);
            #endif
            maxx=bx;maxy=by;maxl=bl;}
    }
    if((maze[by][bx-1].flags & 1 | bx<=0 & NO_WRAP) & 
    (maze[by][bx+1].flags & 1 | bx>=maze_w-1 & NO_WRAP) & 
    (maze[by-1][bx].flags & 1 | by<=0 & NO_WRAP) & 
    (maze[by+1][bx].flags & 1 | by>=maze_h-1 & NO_WRAP)){
    while((maze[by][bx-1].flags & 1 | bx<=0 & NO_WRAP) & 
    (maze[by][bx+1].flags & 1 | bx>=maze_w-1 & NO_WRAP) & 
    (maze[by-1][bx].flags & 1 | by<=0 & NO_WRAP) & 
    (maze[by+1][bx].flags & 1 | by>=maze_h-1 & NO_WRAP) &
    !(bx==bx_start & by==by_start)){
        #ifndef NO_DRAW
        rendersqeen(bx,by);
        #endif
        maze[by][bx].flags=1;
        bx=maze[by][bx].prevx;
        by=maze[by][bx].prevy;
        bl-=2;
    }}
    if(bx!=px | by!=py){
        px=bx;py=by;
    }
    if(bx==bx_start & by==by_start & px==bx_start & py==by_start
    & (maze[bx_start][by_start].flags & 1)){
        drawmaze(1);
        #ifndef NO_SAVE
        install_mouse();
        if(file_select_ex("Save maze image",fname,"PCX", 512, 640, 480)){
        save_pcx(fname,mazeb,NULL);
        }
        remove_mouse();
        #else
        blit(mazeb,blah,camx,camy,0,0,640,480);
        blit(blah,screen,0,0,0,0,640,480);
        rest(1000);
        #endif
        clearmaze();
    }
}

int main(int argc, char *argv[]) {
    allegro_init();
    install_timer();
    install_keyboard();
    maze_w=80;maze_h=60;
    bx_start=0;by_start=0;
    draw_delay=50;
    #ifndef EDITMODE
    maze_w=askatoi("Width:");
    maze_h=askatoi("Height:");
    #endif
    bx_start=askatoi("Start X:");
    by_start=askatoi("Start Y:");
    #ifndef NO_DRAW
    #ifndef EDITMODE
    draw_delay=askatoi("Draw delay:");
    #endif
    #endif

    set_color_depth(32);
    set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,480,0,0);
    set_window_title(
    "daze.maze - advanced dfs maze generator by thematrixeatsyou@yahoo.co.nz");
    
    // Initial stuff
    blah=create_bitmap(800,600);
    mazeb=create_bitmap(maze_w*8,maze_h*8);
    clearmaze();
    
    // Main App Loop
    #ifdef EDITMODE
    gamemode=gm_edit;
    #else
    gamemode=gm_play;
    #endif
    while(gamemode!=gm_quit){
    poll_keyboard();
        switch (gamemode){
        case gm_play:
            gameloop();
            break;
        case gm_edit:
            editloop();
            break;
        }
    if(key[KEY_ESC]){gamemode=gm_quit;}
    //rest();
    }
    return 0;
}
END_OF_MAIN();
