#ifndef _GUI_H_
#define _GUI_H_

#include "main.h"

typedef struct GUI GUI;
typedef struct GUI_BUTTON GUI_BUTTON;

struct GUI_BUTTON
{
  GUI *gui;
  int index;
  void (*callback) (GUI *self, int bin);
};

struct GUI
{
  DIALOG *dialog;
  DIALOG_PLAYER *dp;
  BITMAP *background;
  BITMAP *screen;
  BITMAP *realscreen;
};

GUI *gui_new (void);
DIALOG *gui_add_push_button (GUI *self, char const *name, void (*callback) (GUI *self, int index));
void gui_finalize (GUI *self);
void gui_redraw (GUI *self);
void gui_del (GUI *self);
void gui_render (GUI *self);
void gui_process (GUI *self);
void gui_resize (GUI *self);
DIALOG *gui_get_button (GUI *gui, char const *name);

#endif
