#include "data.h"

char *datapath;
BITMAP *bitmap[BITMAPS_COUNT];
SAMPLE *sample[SAMPLES_COUNT];
BITMAP *robo[70];
BITMAP *laser[7];
MIDI *midi;
char **text[TEXTS_COUNT];

static int failed;

static void
bitmap_load (BITMAP_ID id, char const *name)
{
  char str[1024];
  if (failed)
    return;
  strcpy (str, datapath);
  strcat (str, name);
  bitmap[id] = load_bitmap (str, NULL);
  if (!bitmap[id])
  {
    failed++;
  }
}

static void
sample_load (SAMPLE_ID id, char const *name)
{
  char str[1024];
  if (failed)
    return;
  strcpy (str, datapath);
  strcat (str, name);
  sample[id] = load_sample (str);
  if (!sample[id])
  {
    failed++;
  }
}

static void
text_load (SAMPLE_ID id, char const *name)
{
  char str[1024];
  PACKFILE *file;
  if (failed)
    return;
  strcpy (str, datapath);
  strcat (str, name);
  text[id] = NULL;
  file = pack_fopen (str, "r");
  if (file)
  {
    int c;
    char linetext[256];
    char **thetext = NULL;
    int linepos = 0;
    int lines = 0;
    while (1)
    {
      c = pack_getc (file);
      if (c >= 32)
      {
        linetext[linepos] = c;
        if (linepos < 254)
          linepos++;
      }
      if (c == '\n' || c == -1)
      {
        linetext[linepos] = '\0';
        thetext = realloc (thetext, (lines + 2) * sizeof *text);
        thetext[lines] = malloc (linepos + 1);
        strcpy (thetext[lines], linetext);
        thetext[lines + 1] = NULL;
        linepos = 0;
        lines++;
      }
      if (c == -1)
        break;
    }
    text[id] = thetext;
    pack_fclose (file);
  }
  if (!text[id])
  {
    failed++;
  }
}

static void
midi_load (char const *name)
{
  char str[1024];
  if (failed)
    return;
  strcpy (str, datapath);
  strcat (str, name);
  midi = load_midi (str);
  if (!midi)
  {
    failed++;
    return;
  }
  set_volume (-1, 155);
  play_midi (midi, 1);
}

int
data_load (void)
{
  static int once = 1;
  failed = 0;
  if (once)
  {
    int i, j;
    set_color_conversion (COLORCONV_TOTAL | COLORCONV_KEEP_TRANS);

    midi_load ("mars.mid");

    bitmap_load (BITMAP_ICON, "icon.bmp");
    bitmap_load (BITMAP_ROBO, "robo.bmp");
    bitmap_load (BITMAP_SOIL, "soil.bmp");
    bitmap_load (BITMAP_LASER, "laser.bmp");
    bitmap_load (BITMAP_VOID, "void.bmp");
    bitmap_load (BITMAP_TITLE, "title.bmp");
    bitmap_load (BITMAP_SPLASH, "splash.bmp");
    bitmap_load (BITMAP_JELLY, "jelly.bmp");
    bitmap_load (BITMAP_GRAYJELLY, "grayjelly.bmp");
    bitmap_load (BITMAP_GAMEOVER, "gameover.bmp");
    bitmap_load (BITMAP_LIFE, "life.bmp");
    bitmap_load (BITMAP_CRYSTAL, "crystal.bmp");
    bitmap_load (BITMAP_CONGRATS, "congrats.bmp");

    sample_load (SAMPLE_STEP, "step.wav");
    sample_load (SAMPLE_FIRE, "fire.wav");
    
    text_load (TEXT_INTRO, "intro.txt");

    for (j = 0; j < 7; j++)
    {
      for (i = 0; i < 10; i++)
      {
        robo[j * 10 + i] = create_sub_bitmap (bitmap[BITMAP_ROBO], i * 48, j * 48, 48, 48);
      }
      laser[j] = create_sub_bitmap (bitmap[BITMAP_LASER], j * 16, 0, 16, 16);
    }
    once = 0;
  }
  return failed;
}
