#include "init.h"
#include "menu.h"
#include "data.h"

static int pos;
static int next;
static int linepos;
static int speed;

struct
{
  char const *line;
  int x, y;
}
blah[256];

int blahnum;

static int
_init (void)
{
  if (data_load ())
    return 1;
  
  set_volume (-1, 155);
  
  pos = 0;
  next = 0;
  linepos = 0;
  blahnum = 0;
  speed = 1;

  return 0;
}

static void
_done (void)
{
  
}

static void
_frame (void)
{
  int i;
  if (keypressed ())
  {
    readkey ();
    run_switch (&menu_run_state);
    return;
  }
  
  if (pos >= next)
  {
    i = blahnum;
    blah[i].line = text[TEXT_INTRO][linepos];
    if (blah[i].line)
    {
      if (blah[i].line[0] == '\\')
      {
        int num = strtol (blah[i].line + 2, NULL, 0);
        if (blah[i].line[1] == 'r')
        {
          blah[i].x = page->w / 2 - robo[num]->w / 2;
          blah[i].y = page->h;
          blahnum++;
        }
        if (blah[i].line[1] == 'l')
        {
          blah[i].x = page->w / 2 - laser[num]->w / 2;
          blah[i].y = page->h;
          blahnum++;
        }
        if (blah[i].line[1] == 'i')
        {
          blah[i].x = page->w / 2 - bitmap[num]->w / 2;
          blah[i].y = page->h;
          blahnum++;
        }
        if (blah[i].line[1] == 's')
        {
          next = pos + num * speed;
        }
        if (blah[i].line[1] == 'm')
        {
          speed = num;
        }
        linepos++;
      }
      else
      {
        blah[blahnum].x = page->w / 2 - text_length (font, blah[blahnum].line) / 2;
        blah[blahnum].y = page->h;
        next = pos + speed * text_height (font) + speed;
        linepos++;
        blahnum++;
      }
    }
    else
      linepos = 0;
  }
  
  pos++;
  if ((pos % speed) == speed - 1)
  {
    for (i = 0; i < blahnum; i++)
    {
      blah[i].y--;
    }
  }
}

static void
_render (void)
{
  int i;
  blit (bitmap [BITMAP_TITLE], page, 0, 0, 0, 0, 320, 240);
  for (i = 0; i < blahnum; i++)
  {
    if (blah[i].line)
    {
      if (blah[i].line[0] == '\\')
      {
        int num = strtol (blah[i].line + 2, NULL, 0);
        if (blah[i].line[1] == 'r')
        {
          draw_sprite (page, robo[10 * num], blah[i].x, blah[i].y);
        }
        if (blah[i].line[1] == 'l')
        {
          draw_sprite (page, laser[num], blah[i].x, blah[i].y);
        }
        if (blah[i].line[1] == 'i')
        {
          draw_sprite (page, bitmap[num], blah[i].x, blah[i].y);
        }
      }
      else
      {
        textprintf_ex (page, font, blah[i].x, blah[i].y,
          makecol (255, 255, 255), -1, "%s", blah[i].line);
      }
    }
  }
}

RUN_STATE init_run_state = {_init, _done, _frame, _render};
