#include "run.h"
#include "game.h"
#include "menu.h"
#include "data.h"
#include "map.h"
#include "robo.h"

int step = 0;
int anim = 0;
int gameover = 1;
int win = 0;

int show_fps = 0;

static int
_init (void)
{
  data_load ();

  if (gameover || win)
  {
    generateMap ();
    gameover = 0;
    win = 0;
  }

  set_volume (-1, 60);

  return 0;
}

static void
_done (void)
{

}

static void
_frame (void)
{
  while (keypressed ())
  {
    int k = readkey ();

    k >>= 8;
    if (k == KEY_ESC)
    {
      run_switch (&menu_run_state);
    }
    if (k == KEY_F)
      show_fps = !show_fps;
  }

  if (robos[1].life > 0 && !robos[1].win)
  {
    moveRobos ();
  }
  else
  {
    if (robos[1].life <= 0 && !gameover)
    {
      gameover = 1;
      set_volume (-1, 155);
    }
    if (robos[1].win && !win)
    {
      win = 1;
    }
  }
}

static void
drawJelly (void)
{
  int x = robos[1].life;
  masked_blit (bitmap[BITMAP_JELLY], page, 0, 0, 0, 68, x, 16);
  masked_blit (bitmap[BITMAP_GRAYJELLY], page, x, 0, x, 68, 64 - x, 16);
}

static void
_render (void)
{
  int sprite = 0;
  drawMap ();
  drawRobos ();
  drawJelly ();
  drawSat ();

  if (robos[1].life <= 0)
    sprite = BITMAP_GAMEOVER;
  if (robos[1].win)
    sprite = BITMAP_CONGRATS;
  if (sprite)
    draw_sprite (page, bitmap[sprite],
      page->w / 2 - bitmap[sprite]->w / 2,
      page->h / 2 - bitmap[sprite]->h / 2);

  if (show_fps)
    textprintf_right_ex (page, font, page->w, 0,
                    makecol (100, 100, 100), -1, "%i fps", run_fps);
}

RUN_STATE game_run_state = {_init, _done, _frame, _render};
