#include "run.h"

#if defined(ALLEGRO_WINDOWS)
#include <winalleg.h>
#endif

int run_quit;
int run_frames;
int run_fps;
RUN_STATE *run_state;

static volatile int ticks;
static void
ticker (void)
{
  ticks++;
}
END_OF_FUNCTION (ticker)

static int
run_init (void)
{
  return run_state->init ();
}

static void
run_exit (void)
{
  run_state->exit ();
}

static void
run_frame (void)
{
  run_state->frame ();
}

static void
run_render (void)
{
 run_state->render ();
}

int
run_switch (RUN_STATE *state)
{
  run_exit ();
  run_state = state;
  return run_init ();
}

int
run (RUN_STATE *state)
{
  int gframes;
  int framecounttime, framecounter;
  
  ticks = 0;  
  
  LOCK_FUNCTION (ticker);
  LOCK_VARIABLE (ticks);

  install_int_ex (ticker, BPS_TO_TIMER (FPS));

  run_state = state;
  if (run_init ())
  {
    allegro_message ("Initialization failed.\n");
    return 1;
  }

  run_quit = 0;
  run_fps = 0;
  framecounter = 0;
  framecounttime = ticks;
  gframes = ticks;
  run_frames = ticks;
  while (!run_quit)
  {
    while (run_frames <= ticks)
    {
      run_frame ();
      run_frames++;
    }
    if (gframes < run_frames)
    {
      /* Render (normally offscreen). */
      run_render ();

      /* Make visible what was previously rendered. */
      gfx_flip ();

      gframes = run_frames;
      framecounter++;

      if (ticks - framecounttime >= FPS)
      {
        run_fps = framecounter;
        framecounter = 0;
        framecounttime = ticks;
      }
    }
    else
    {
      /* If we have some spare time left - give it back to the OS. */
      #ifdef ALLEGRO_LINUX
        struct timeval tv = {0, 1};
        select (0, NULL, NULL, NULL, &tv); 
      #elif defined(ALLEGRO_WINDOWS)
        Sleep (1);
      #else
        yield_timeslice ();
      #endif
    }
  }
  run_exit ();
  return 0;
}
