#include <allegro.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "run.h"
#include "data.h"
#include "init.h"

BITMAP *page;

int fullscreen;
int colordepth;
int screenwidth;
int screenheight;
int double_scan;

static void
switch_cb (void)
{
  
}

static void
close_cb (void)
{
  simulate_keypress (KEY_ESC << 8);
}

int
gfx_reset_mode (void)
{
  int vm = fullscreen ? GFX_AUTODETECT : GFX_AUTODETECT_WINDOWED;
  
  set_color_depth (colordepth);

  if (set_gfx_mode (vm, screenwidth, screenheight, 0, 0) < 0)
  {
    return 0;
  }

  if (set_display_switch_mode (SWITCH_BACKGROUND))
    set_display_switch_mode (SWITCH_BACKAMNESIA);

  set_display_switch_callback (SWITCH_IN, switch_cb);

  return 1;
}

void
gfx_flip (void)
{
  
  /* Simple double buffer. */
  if (double_scan)
    stretch_blit (page, screen, 0, 0, page->w, page->h, 0, 0, SCREEN_W, SCREEN_H);
  else
    blit (page, screen, 0, 0, 0, 0, page->w, page->h);
}

extern int _mangled_main (void);
int
main (void)
{
  srand ((unsigned)time (NULL));
  allegro_init ();
  {
    char str[1024];
    get_executable_name (str, 1024);
    replace_filename(str, str, "", 1024);
    datapath = strdup (str);
    printf ("Data path: %s\n", datapath);
  }

  colordepth = desktop_color_depth ();
  screenwidth = 320;
  screenheight = 240;
  fullscreen = 1;
  double_scan = 0;

  gfx_reset_mode ();

  set_close_button_callback (close_cb);
  
  install_keyboard ();

  install_mouse ();

  install_timer ();

  set_volume_per_voice (1);
  install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);

  if (double_scan)
    page = create_bitmap (SCREEN_W / 2, SCREEN_H / 2);
  else
    page = create_bitmap (SCREEN_W, SCREEN_H);
  
  run (&init_run_state);

  return 0;
}
END_OF_MAIN ()
