#ifndef _ROBO_H_
#define _ROBO_H_

typedef struct Robo Robo;
typedef struct Laser Laser;
  
extern int collision_map[65536];
 
#include "main.h"

#define ROBOCOUNT 1024

struct Robo
{
  float x, y, a;
  int step;
  int anim;
  int fire;
  int fire_side : 2;
  int alive : 2;
  int clockwise : 2;
  int awake : 2;
  int win : 2;
  int dir;
  int level;
  int wander;
  int life;
};

struct Laser
{
  float x, y, a, d;
  float z;
  int alive : 2;
  int player : 2;
  int level;
  int splash;
};

extern Robo robos[ROBOCOUNT];
extern Laser lasers[256];

void moveRobos (void);
int addRobo (float x, float y, float a);
void drawRobos (void);
void clearRobos (void);
int checkTile (float x, float y);
void wakeUp (void);

#endif
