#include "menu.h"
#include "game.h"
#include "gui.h"
#include "data.h"

GUI *global_gui = NULL;

static void
_play (GUI *self, int bin)
{
  DIALOG *d = self->dialog + bin;
  (void) d;
  run_switch (&game_run_state);
}

static void
_quit (GUI *self, int bin)
{
  DIALOG *d = self->dialog + bin;
  (void) d;
  run_quit = 1;
}

static void
_music (GUI *self, int bin)
{
  DIALOG *d = self->dialog + bin;
  char *str = d->dp;
  if (str[0] == 'X')
  {
    str[0] = '_';
    midi_pause ();
  }
  else
  {
    str[0] = 'X';
    midi_resume ();
  }
}

static void
_fullscreen (GUI *self, int bin)
{
  DIALOG *d = self->dialog + bin;
  char *str = d->dp;
  if (str[0] == 'X')
  {
    str[0] = '_';
    fullscreen = 0;
  }
  else
  {
    str[0] = 'X';
    fullscreen = 1;
  }
  screen = self->realscreen;
  gfx_reset_mode ();
  self->realscreen = screen;
  gui_resize (self);
  gui_redraw (self);
  screen = self->screen;
}

static void
_stretch (GUI *self, int bin)
{
  DIALOG *d = self->dialog + bin;
  char *str = d->dp;
  if (str[0] == 'X')
  {
    str[0] = '_';
    double_scan = 0;
    screenwidth = 320;
    screenheight = 240;
  }
  else
  {
    str[0] = 'X';
    double_scan = 1;
    screenwidth = 640;
    screenheight = 480;
  }
  screen = self->realscreen;
  gfx_reset_mode ();
  self->realscreen = screen;
  gui_resize (self);
  gui_redraw (self);
  screen = self->screen;
}


static int
_init (void)
{
  if (data_load ())
    return 1;
  if (!global_gui)
  {
    DIALOG *d;
    global_gui = gui_new ();
    d = gui_add_push_button (global_gui, "Play", _play);
    d = gui_add_push_button (global_gui, "X Music", _music);
    d = gui_add_push_button (global_gui, "_ Fullscreen", _fullscreen);
    if (fullscreen)
      ((char *)d->dp)[0] = 'X';
    d = gui_add_push_button (global_gui, "_ Stretch 2x", _stretch);
    if (double_scan)
      ((char *)d->dp)[0] = 'X';
    d = gui_add_push_button (global_gui, "Quit", _quit);
    d->key = 27;
    global_gui->background = bitmap[BITMAP_TITLE];
    gui_finalize (global_gui);
  }
  set_volume (-1, 155);
  return 0;
}

static void
_done (void)
{
  
}

static void
_frame (void)
{
  gui_process (global_gui);
}

static void
_render (void)
{
  gui_render (global_gui);
  draw_sprite (page, mouse_sprite, mouse_x, mouse_y);
}

RUN_STATE menu_run_state = {_init, _done, _frame, _render};
