#include "gui.h"

DIALOG *
gui_get_button (GUI *gui, char const *name)
{
  DIALOG *dialog;
  for (dialog = gui->dialog; dialog->proc; dialog++)
    if (!strcmp (dialog->dp, name))
      return dialog;
  return NULL;
}

static int
d_mybutton_proc (int msg, DIALOG *d, int c)
{
  GUI_BUTTON *button = d->dp2;
  if (msg == MSG_LRELEASE || msg == MSG_KEY)
  {
    button->callback (button->gui, button->index);
    return D_REDRAW;
  }
  if (msg == MSG_DRAW)
  {
    int x, y, w, h, r;
    int tcol, bcol, fcol;
    BITMAP *tmp = create_bitmap (text_length (font, d->dp), text_height (font));
    BITMAP *tmp2;
    tcol = makecol (155, 55, 55);
    bcol = makecol (100, 100, 100);
    fcol = makecol (150, 150, 150);
    if (d->flags & D_GOTFOCUS)
    {
      tcol = makecol (155, 0, 0);
      bcol = makecol (255, 255, 200);
      fcol = makecol (200, 200, 200);
    }
    if (d->flags & D_DISABLED)
    {
      tcol = makecol (100, 100, 100);
      bcol = makecol (150, 150, 150);
      fcol = makecol (100, 100, 100);
    }

    textout_ex (tmp, font, d->dp, 0, 0, tcol, bitmap_mask_color (tmp));
    h = d->h - 12;
    w = tmp->w * h / tmp->h;
    
    if (w > 2 * d->w / 3)
      w = 2 * d->w / 3;
    
    tmp2 = create_bitmap (w, h);
    stretch_blit (tmp, tmp2, 0, 0, tmp->w, tmp->h, 0, 0, w, h);
    destroy_bitmap (tmp);
    
    x = d->x + (d->w - w) / 2;
    y = d->y;
    r = h / 2 + 3;
    
    blit (button->gui->background, screen, x + 6 - r, y - 3, x + 6 - r, y - 3,
      w - 10 + r + r, h + 7);
    
    set_luminance_blender (0, 0, 0, (d->flags & D_GOTFOCUS) ? 192 : 255);
    drawing_mode (DRAW_MODE_TRANS, NULL, 0, 0);

    rectfill (screen, x + 6, y - 3, x + w - 6, y + h + 3, fcol);
    set_clip (screen, 0, 0, x + 6 - 1, screen->h - 1);
    circlefill (screen, x + 6, y + h / 2, r, fcol);
    set_clip (screen, x + w - 6 + 1, 0, screen->w - 1, screen->h - 1);
    circlefill (screen, x + w - 6, y + h / 2, r, fcol);
    set_clip (screen, 0, 0, screen->w - 1, screen->h - 1);
    //arc (screen, x + 6, y + h / 2, itofix (64), itofix (192), r, bcol);
    //arc (screen, x + w - 6, y + h / 2, itofix (192), itofix (64), r, bcol);
    //hline (screen, x + 6, y - 3, x + w - 6, bcol);
    //hline (screen, x + 6, y + h + 3, x + w - 6, bcol);
    draw_trans_sprite (screen, tmp2, x, y);
    destroy_bitmap (tmp2);
    solid_mode ();
    return D_O_K;
  }

  return d_button_proc (msg, d, c);
}

static DIALOG *
_add_button (DIALOG **d, char const *str)
{
  int i;
  //int w = text_length (font, str) * 28 / text_height (font) + 40;
  for (i = 0; *d && (*d)[i].proc; i++);
  *d = realloc (*d, (i + 2) * sizeof **d);
  memset (*d + i, 0, 2 * sizeof **d);
  (*d + i)->proc = d_mybutton_proc;
  (*d + i)->dp = strdup (str);
  (*d + i)->x = 0; //SCREEN_W / 2 - w / 2;
  (*d + i)->y = i * 40;
  (*d + i)->w = 320; //w;
  (*d + i)->h = 40;
  (*d + i)->fg = makecol (255, 255, 255);
  (*d + i)->bg = makecol (0, 0, 0);
  return *d + i;
}

GUI *
gui_new (void)
{
  GUI *self = calloc (1, sizeof *self);
  return self;
}
  
DIALOG *
gui_add_push_button (GUI *self, char const *name, void (*callback) (GUI *gui, int index))
{
  DIALOG *d;
  GUI_BUTTON *button;
  d = _add_button (&self->dialog, name);
  button = calloc (1, sizeof *button);
  button->gui = self;
  button->index = d - self->dialog;
  button->callback = callback;
  d->dp2 = button;
  return d;
}

void
gui_finalize (GUI *self)
{
  self->dp = init_dialog (self->dialog, 0);
  self->screen = NULL;
  gui_resize (self);
  blit (self->background, self->screen, 0, 0, 0, 0, page->w, page->h);
}

void
gui_redraw (GUI *self)
{
  blit (self->background, self->screen, 0, 0, 0, 0,
      page->w, page->h);
  broadcast_dialog_message (MSG_DRAW, 0);
}

void
gui_resize (GUI *self)
{
  int i, h = 0, y;
  if (self->screen)
    destroy_bitmap (self->screen);
  self->screen = create_bitmap (SCREEN_W, SCREEN_H);
  for (i = 0; self->dialog[i].dp; i++)
  {
    h += self->dialog[i].h;
  }
  y = (page->h - h) / 2;
  for (i = 0; self->dialog[i].dp; i++)
  {
    self->dialog[i].y = y;
    y += self->dialog[i].h;
  }
  set_mouse_range (0, 0, page->w - 1, page->h - 1);
}

void
gui_del (GUI *self)
{
  int i;
  for (i = 0; self->dialog[i].proc; i++)
  {
    if (self->dialog[i].proc == d_mybutton_proc)
      free (self->dialog[i].dp);
  }
  free (self->dialog);
  free (self);
}

void
gui_process (GUI *self)
{
  self->realscreen = screen;
  screen = self->screen;
  update_dialog (self->dp);
  screen = self->realscreen;
}

void
gui_render (GUI *self)
{
  blit (self->screen, page, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}
