#include "player.h"
#include "resources.h"
#include "anim.h"
#include "engine.h"
#include "main.h"
#include "monster.h"

Player::Player()
{
    visible = true;
    current = NULL;
    hittimer = 0;
    bullettimer = 0;
    weaponType = 0;
    w = 24;
    h = 24;
    sprdx = -12;
    sprdy = -4;
}

Anim *Player::normal;

SAMPLE *Player::shoot;
SAMPLE *Player::explode;
SAMPLE *Player::bonus;

void Player::init(Resources *res)
{
    normal = res->getAnim ("PLAYER");
    shoot = res->getSample ("SHOOT");
    explode = res->getSample ("EXPL");
    bonus = res->getSample ("BLIP");
}

void Player::update()
{
    assert (parent);
    if (!current) setAnim(normal);
    
    if (hittimer > 0)
    {
        hittimer--;
        visible = !(hittimer & 1);
    }
    
    // weapon cheat
    //~ static bool previous_pgup = false;
    //~ if (previous_pgup && !key[KEY_PGUP])
    //~ {
        //~ parent->getParent()->bonusCount += 6;        
    //~ }
    //~ previous_pgup = key[KEY_PGUP];
    
    weaponType = parent->getParent()->bonusCount / 6;
    if (weaponType > 6) weaponType = 6;
    
    if (!key[KEY_SPACE]) bullettimer = 0;
    if (bullettimer > 0)
    {
        bullettimer--;
    }
    else
    {
        if (key[KEY_SPACE])
        {
            const int bullet_xofst = 32;
            const int bullet_yofst = 18;
            const int yspeed = 7;
            bullettimer = 6;
	    parent->getParent()->getParent()->playSample (shoot);
            switch (weaponType)
            {
                case 0:     
                {
                    Bullet *bullet = new Bullet(Bullet::HE, 10, 0);            
                    parent->add (bullet);
                    bullet->setLocation (getx() + bullet_xofst, gety() + bullet_yofst);
                    break;
                }
                case 1:            
                {
                    Bullet *bullet = new Bullet(Bullet::HE, 10, 0);            
                    parent->add (bullet);
                    bullet->setLocation (getx() + bullet_xofst, gety() + bullet_yofst);
                    bullet = new Bullet(Bullet::HE, 10, yspeed);            
                    parent->add (bullet);
                    bullet->setLocation (getx() + bullet_xofst, gety() + bullet_yofst);
                    break;
                }
                case 2:            
                {
                    Bullet *bullet = new Bullet(Bullet::O2, 10, 0);            
                    parent->add (bullet);
                    bullet->setLocation (getx() + bullet_xofst, gety() + bullet_yofst);
                    bullet = new Bullet(Bullet::HE, 10, yspeed);            
                    parent->add (bullet);
                    bullet->setLocation (getx() + bullet_xofst, gety() + bullet_yofst);
                    break;
                }
                case 3:            
                {
                    Bullet *bullet = new Bullet(Bullet::NH3, 10, 0);            
                    parent->add (bullet);
                    bullet->setLocation (getx() + bullet_xofst, gety() + bullet_yofst);
                    bullet = new Bullet(Bullet::HE, 10, yspeed);            
                    parent->add (bullet);
                    bullet->setLocation (getx() + bullet_xofst, gety() + bullet_yofst);
                    break;
                }
                case 4:            
                {
                    Bullet *bullet = new Bullet(Bullet::NH3, 10, 0);            
                    parent->add (bullet);
                    bullet->setLocation (getx() + bullet_xofst, gety() + bullet_yofst);
                    bullet = new Bullet(Bullet::HE, 10, yspeed);            
                    parent->add (bullet);
                    bullet->setLocation (getx() + bullet_xofst, gety() + bullet_yofst);
                    bullet = new Bullet(Bullet::HE, 10, -yspeed);            
                    parent->add (bullet);
                    bullet->setLocation (getx() + bullet_xofst, gety() + bullet_yofst);
                    break;
                }                
                case 5:            
                {
                    Bullet *bullet = new Bullet(Bullet::CH4, 10, 0);            
                    parent->add (bullet);
                    bullet->setLocation (getx() + bullet_xofst, gety() + bullet_yofst);
                    bullet = new Bullet(Bullet::HE, 10, yspeed);            
                    parent->add (bullet);
                    bullet->setLocation (getx() + bullet_xofst, gety() + bullet_yofst);
                    bullet = new Bullet(Bullet::HE, 10, -yspeed);            
                    parent->add (bullet);
                    bullet->setLocation (getx() + bullet_xofst, gety() + bullet_yofst);
                    break;
                }                
                case 6:            
                {
                    Bullet *bullet = new Bullet(Bullet::CH4, 10, 0);            
                    parent->add (bullet);
                    bullet->setLocation (getx() + bullet_xofst, gety() + bullet_yofst);
                    bullet = new Bullet(Bullet::O2, 10, yspeed);            
                    parent->add (bullet);
                    bullet->setLocation (getx() + bullet_xofst, gety() + bullet_yofst);
                    bullet = new Bullet(Bullet::O2, 10, -yspeed);            
                    parent->add (bullet);
                    bullet->setLocation (getx() + bullet_xofst, gety() + bullet_yofst);
                    break;
                }                
                default:
                    assert (false); // shouldn't occur
            }
            
        }
    }
    
    fix dx = 0, dy = 0;
    if (key[KEY_UP] && gety() > 0)
    {
        dy = -4;
    }
    if (key[KEY_DOWN] && gety() + geth() < 240)
    {
        dy = 4;
    }
    if (key[KEY_LEFT] && getx() > 0)
    {
        dx = -4;
    }
    if (key[KEY_RIGHT] && getx() + getw() < 320)
    {
        dx = 4;
    }
    try_move (dx, dy);
    Object::update();
    w = 24;
    h = 24;
}

void Player::hit()
{
    hittimer = 25;
    Engine *e = parent->getParent();
    parent->getParent()->getParent()->playSample (explode);
    if (!e->isDebug())
    {
        e->die(); // send die signal
        kill();
    }    
}

void Player::handleCollission (Object *o)
{
    if (o->getType() == 4) // monster
    {
        Explosion *e = new Explosion();
        e->setLocation(getx() + getw() / 2 - 30, gety() + geth() / 2 - 30);
        parent->add(e);
        hit();
    }
    if (o->getType() == 5) // bonus
    {
        parent->getParent()->bonusCount++;
	parent->getParent()->getParent()->playSample (bonus);    
    }
}
