#include "monster.h"
#include "resources.h"
#include "engine.h"
#include "main.h"
#include <stdlib.h>

Anim *Bullet::bullet[5];

Bullet::Bullet(int _bulletType, int _dx, int _dy) 
   : bulletType(_bulletType), dx (_dx), dy (_dy)
{
    visible = true;
    current = NULL;
}

void Bullet::init(Resources *res)
{
    bullet[HE] = res->getAnim ("HE");
    bullet[O2] = res->getAnim ("O2_2");
    bullet[H2O] = res->getAnim ("H2O_2");
    bullet[NH3] = res->getAnim ("NH3_2");
    bullet[CH4] = res->getAnim ("CH4_2");
}

void Bullet::update()
{
    if (!current) setAnim (bullet[bulletType]);
    Object::update();
    
    try_move (dx, dy);
    if (getx() > 320) kill();
}

void Bullet::handleCollission(Object *o)
{
    if (o->getType() == 4) // monster
    {
        kill();
    }
}

Anim *Explosion::explosion;

Explosion::Explosion()
{
    visible = true;
    current = NULL;    
    life = 10;
}

void Explosion::init(Resources *res)
{
    explosion = res->getAnim ("EXPLOSION");    
}

void Explosion::update()
{
    if (!current) setAnim (explosion);
    Object::update();
    
    try_move (-1, 0);
    
    life--;    
    if (life <= 0) kill();
}


Anim *Bonus::bonus;

Bonus::Bonus()
{
    visible = true;
    current = NULL;    
}

void Bonus::init(Resources *res)
{
    bonus = res->getAnim ("BONUS");    
}

void Bonus::update()
{
    if (!current) setAnim (bonus);
    Object::update();
    
    try_move (-1, 0);
    
    if (getx() + getw() < 0) kill();
}

void Bonus::handleCollission(Object *o)
{
    if (o->getType() == 1) kill(); // player
}

Anim *Monster::monster [15];
Anim *Monster::hit [15];
SAMPLE *Monster::explode;

//~ MovePattern mpStopGo[] = {
    //~ {Monster::mvStop, 0, 0, 0, 40},
    //~ {Monster::mvHoriz, -1, 0, 0, 40},
    //~ {Monster::mvStop, 0, 0, 0, 0}
//~ }

Monster::Monster(int _monsterType, int _moveType, fix param1, fix param2, fix param3, int x, int y) 
   : monsterType(_monsterType), moveType (_moveType)
{
    visible = true;
    current = NULL;
   
    basex = 0;
    basey = 0;
    period = 0;
    radius = 0;
    phase = 0;
    dx = 0;
    dy = 0;
    
    wasHit = false;
    
    switch (monsterType)
    {
        case rock1:
        case rock2:
        case rock3:
        case spark:
            hp = 9999;
            scoreValue = 0;
            break;
        case bigcube: // boss
            hp = 201;
            shoottimer = 60;
            scoreValue = 1024;
            break;
        case bigpyramid:
            hp = 41;
            shoottimer = 1;
            scoreValue = 80;
            break;
        case cube:
            hp = 14;
            shoottimer = 1;
            scoreValue = 52;
            break;        
        default:
            hp = 5;
            scoreValue = 24;
    }
    
    switch (moveType)
    {
        case mvStop:
            moveType = mvDxdy;
            dx = -1;
            dy = 0;
            break;
        case mvSin:
            period = param1;
            radius = param2;
            phase = param3;
            break;
        case mvAbsSin:
            period = param1;
            radius = param2;
            phase = param3;
            break;
        case mvGoCircle:
            period = param1;
            radius = param2;
            phase = param3;
            break;
        case mvHoldCircle:
            period = param1;
            radius = param2;
            phase = param3;
            break;
        case mvDxdy:
            dx = param1;
            dy = param2;
            break;
        case mvVert:
            moveType = mvDxdy;
            dx = -1;
            dy = param1;
            break;
        case mvHoriz:
            moveType = mvDxdy;
            dx = -1 - param1;
            dy = 0;
            break;
        default:
            assert (false);
    }
    setLocation (x, y);
}

void Monster::init(Resources *res)
{
    monster[cube] = res->getAnim ("CUBE");
    monster[rock1] = res->getAnim ("ROCK1");
    monster[rock2] = res->getAnim ("ROCK2");
    monster[rock3] = res->getAnim ("ROCK3");
    monster[spark] = res->getAnim ("SPARK");
    monster[bigpyramid] = res->getAnim ("PBIG");
    monster[bigcube] = res->getAnim ("CUBEBIG");
    monster[pblue] = res->getAnim ("PBLUE");
    monster[pgreen] = res->getAnim ("PGREEN");
    monster[pgrey] = res->getAnim ("PBLUE");
    monster[ppink] = res->getAnim ("PPINK");
    monster[ppurple] = res->getAnim ("PPURPLE");
    monster[pred] = res->getAnim ("PRED");
    monster[pyellow] = res->getAnim ("PYEL");   
    monster[plblue] = res->getAnim ("PLBLUE");    
    
    explode = res->getSample ("EXPL");
    
    hit[cube] = res->getAnim ("HCUBE");
    hit[rock1] = res->getAnim ("ROCK1");
    hit[rock2] = res->getAnim ("ROCK2");
    hit[rock3] = res->getAnim ("ROCK3");
    hit[spark] = res->getAnim ("SPARK");
    hit[bigpyramid] = res->getAnim ("HPBIG");
    hit[bigcube] = res->getAnim ("HCUBEBIG");
    hit[pblue] = res->getAnim ("HPBLUE");
    hit[pgreen] = res->getAnim ("HPGREEN");
    hit[pgrey] = res->getAnim ("HPBLUE");
    hit[ppink] = res->getAnim ("HPPINK");
    hit[ppurple] = res->getAnim ("HPPURPLE");
    hit[pred] = res->getAnim ("HPRED");
    hit[pyellow] = res->getAnim ("HPYEL");   
    hit[plblue] = res->getAnim ("HPLBLUE");    
}

void Monster::update()
{
    if (!current || wasHit) 
    {
        setAnim (monster[monsterType]);
        wasHit = false;
    }
    Object::update();
    
    fix lasty = gety();
    fix newy;
    fix lastx = getx();
    fix newx;
    
    phase += 1;
        
    switch (moveType)
    {
        case mvDxdy:
            try_move (dx, dy);
            break;
        case mvSin:
            newy = basey + sin (fix (((int)(phase) % int(period)) * 256 / int(period))) * radius;
            try_move (-1, newy - lasty);
            break;
        case mvGoCircle:
            basex--;
            newy = basey - sin (fix (((int)(phase) % int(period)) * 256 / int(period))) * radius;
            newx = basex - cos (fix (((int)(phase) % int(period)) * 256 / int(period))) * radius;
            try_move (newx- lastx, newy - lasty);
            break;
        case mvHoldCircle:            
            newy = basey - sin (fix (((int)(phase) % int(period)) * 256 / int(period))) * radius;
            newx = basex - cos (fix (((int)(phase) % int(period)) * 256 / int(period))) * radius;
            try_move (newx- lastx, newy - lasty);
            break;
        default:
            assert (false); // shouldn't occur
    }
    
    switch (monsterType)
    {
        case bigcube: // boss
        shoottimer--;
        if (shoottimer == 0)
        {
            shoottimer = 60;
            parent->add (new Monster (Monster::spark, Monster::mvDxdy,     0,    4,  0,   getx() + getw() / 2,    gety() + geth() / 2));
            parent->add (new Monster (Monster::spark, Monster::mvDxdy,     3,    3,  0,   getx() + getw() / 2,    gety() + geth() / 2));
            parent->add (new Monster (Monster::spark, Monster::mvDxdy,     4,    0,  0,   getx() + getw() / 2,    gety() + geth() / 2));
            parent->add (new Monster (Monster::spark, Monster::mvDxdy,     3,   -3,  0,   getx() + getw() / 2,    gety() + geth() / 2));
            parent->add (new Monster (Monster::spark, Monster::mvDxdy,     0,   -4,  0,   getx() + getw() / 2,    gety() + geth() / 2));
            parent->add (new Monster (Monster::spark, Monster::mvDxdy,    -3,   -3,  0,   getx() + getw() / 2,    gety() + geth() / 2));            
            parent->add (new Monster (Monster::spark, Monster::mvDxdy,    -4,    0,  0,   getx() + getw() / 2,    gety() + geth() / 2));
            parent->add (new Monster (Monster::spark, Monster::mvDxdy,    -3,    3,  0,   getx() + getw() / 2,    gety() + geth() / 2));                        
        }
        break;
        case cube:
        shoottimer--;
        if (shoottimer == 0)
        {
            shoottimer = 60;
            parent->add (new Monster (Monster::spark, Monster::mvDxdy,    -4,    0,  0,   getx() + getw() / 2,    gety() + geth() / 2));
        }
        break;        
        case bigpyramid:
        shoottimer--;
        if (shoottimer == 0)
        {
            shoottimer = 40;
            parent->add (new Monster (Monster::spark, Monster::mvDxdy,    -3,   -3,  0,   getx() + getw() / 2,    gety() + geth() / 2));            
            parent->add (new Monster (Monster::spark, Monster::mvDxdy,    -4,    0,  0,   getx() + getw() / 2,    gety() + geth() / 2));
            parent->add (new Monster (Monster::spark, Monster::mvDxdy,    -3,    3,  0,   getx() + getw() / 2,    gety() + geth() / 2));                        
        }
    }
    if (getx() < -200 || getx() > 600) kill(); // outside of screen
}

void Monster::setLocation (fix nx, fix ny)
{
    Object::setLocation (nx, ny);
    basey = ny;
    basex = nx;
}

void Monster::handleCollission(Object *o)
{
    if (hp != 9999 && o->getType() == 2) // bullet, if hp==9999, can't be destroyed
    {
        wasHit = true;
        setAnim (hit[monsterType]);
        Bullet *b = dynamic_cast<Bullet*>(o);
        assert (b);
        hp -= (b->getBulletType() + 1);
        if (hp <= 0)
        {
	    parent->getParent()->getParent()->playSample(explode);
            Explosion *e = new Explosion();
            e->setLocation(getx() + getw() / 2 - 30, gety() + geth() / 2 - 30);
            parent->add(e);
            kill();
            parent->getParent()->score += scoreValue;
            if (monsterType == bigcube) // boss!
            {
                parent->getParent()->nextLevel(); // restart level                
            }
            else
            {
                if ((rand() % 100) < 20)
                {
                    Bonus *b = new Bonus();
                    b->setLocation (getx() + getw() / 2 - 8, gety() + geth() / 2 - 8);
                    parent->add(b);
                }
            }
        }
    }
}

