#include "menu.h"
#include "misc.h"
#include "main.h"
#include "anim.h"

Menu::Menu(Main *p)
{
    isResume = false;
    parent = p;
}

Menu::~Menu()
{
}
    
void Menu::draw (BITMAP *buffer)
{
    switch (menuState)
    {
        case 0:
            mainMenu.setDirty(); // force redraw
            mainMenu.drawGui (buffer);
            
            draw_rle_sprite (buffer, mouseAnim->getFrame (mouseFrame), mouse_x, mouse_y);
            break;
        case 1:
            break;
        case 2:
            optionsMenu.setDirty(); // force redraw
            optionsMenu.drawGui (buffer);
            
            draw_rle_sprite (buffer, mouseAnim->getFrame (mouseFrame), mouse_x, mouse_y);
            break;
        default : assert (false);
    }
    
}

void Menu::update()
{
    // mouse animation:
    
    // ask current time
    int counter = parent->getCounter();
    
    // if we're lagging behind too much, catch up at once
    if (counter - mouseCounter > 1000) mouseCounter = counter;
    
    // if frametime is 0, loop same frame forever
    if (mouseAnim->getFrameTime (mouseFrame) > 0) 
    // otherwise, see if we need to go to the next frame.
    {
        while (counter - mouseCounter > mouseAnim->getFrameTime (mouseFrame))
        {
            mouseCounter += mouseAnim->getFrameTime (mouseFrame);
            mouseFrame++;
            //allegro_message ("%i, %i", mouseFrame, mouseAnim->getFrameCount());
            if (mouseFrame >= mouseAnim->getFrameCount()) mouseFrame = 0;
        }
    }    

    // menu dialog:
    int result;
    switch (menuState)
    {
        case 0: // normal menu
            result = mainMenu.runGui ();
            switch (result)
            {
                case MainMenu::BUTTONSTART:
                    if (isResume) state = 2; else state = 1;
                    break;
                case MainMenu::BUTTONQUIT:
                    state = 0;
                    break;
                case MainMenu::BUTTONOPTIONS:
		    optionsMenu.setSound (parent->isSoundOn());
                    optionsMenu.setMusic (parent->isMusicOn());
                    optionsMenu.setStereo (parent->isStereoOn());
                    optionsMenu.setHifi (parent->isHifiOn());
                    menuState = 2;
                    break;
            }                
            break;
        case 1: // storyline showing
            if (keypressed() && (readkey() >> 8) == KEY_ESC)
            {
                menuState = 0;                
            }       
            break;
        case 2:
            result = optionsMenu.runGui ();
            switch (result)
            {
                case OptionsMenu::BUTTONRETURN:
                    menuState = 0;
		    parent->setSoundOn (optionsMenu.getSound());
		    parent->setMusicOn (optionsMenu.getMusic());
		    parent->setStereoOn (optionsMenu.getStereo());
		    parent->setHifiOn (optionsMenu.getHifi());
		break;
            }                
            break;
        default : assert (false);
    }    
}

void Menu::init()
{ 
    mouseAnim = parent->getResources()->getAnim ("NH3_2");
    mouseFrame = 0;
    mouseCounter = 0;
    menuState = 0;
}

void Menu::initStart()
{
    isResume = false;
    state = -1;
    parent->playMusic ("MMENU");
    cursor = 0;
    clear_keybuf();
}

void Menu::initResume()
{
    isResume = true;
    state = -1;
    parent->playMusic ("MMENU");
    cursor = 0;
    clear_keybuf();
}


