#include "engine.h"
#include <assert.h>
#include "misc.h"
#include "main.h"
#include "object.h"
#include "player.h"
#include "monster.h"
#include <stdio.h>

LevelEvent level1[]={
    {   0, Engine::wvBlue       , 320,  80},
    {   2, Engine::wvGreen      , 320, 160},
    {   4, Engine::wvCyan       , 320,  80},
    {   9, Engine::wvAsteroid1  , 320,   0},
    {   9, Engine::wvAsteroid2  , 320, 180},
    {  10, Engine::wvAsteroid2  , 320, 120},
    {  10, Engine::wvAsteroid1  , 320,   0},    
    
    {  14, Engine::wvCube       , 320,  60},
    {  15, Engine::wvCube       , 320, 120},
    {  16, Engine::wvCube       , 320, 180},
    {  18, Engine::wvRainbow    , 320, 120},
    {  20, Engine::wvAsteroid1  , 320,   0},
    {  20, Engine::wvAsteroid2  , 320, 180},
    {  21, Engine::wvAsteroid2  , 320, 120},
    {  22, Engine::wvAsteroid1  , 320,   0},    
    
    {  24, Engine::wvCyan       , 320, 160},
    {  26, Engine::wvGreen      , 320,  80},    
    {  28, Engine::wvBlue       , 320, 160},
    {  29, Engine::wvCube       , 320,  40},
    {  30, Engine::wvGreen      , 320,  40},
    {  31, Engine::wvCube       , 320, 160},
    {  32, Engine::wvCyan       , 320, 120},
    {  38, Engine::wvAsteroid2  , 320,   0},
    {  39, Engine::wvAsteroid1  , 320, 180},
    {  40, Engine::wvAsteroid2  , 320, 120},
    {  40, Engine::wvAsteroid1  , 320,   0},    
        
    {  43, Engine::wvCube       , 320, 120},
    {  44, Engine::wvCube       , 320, 140},
    {  45, Engine::wvCube       , 320, 100},
    {  46, Engine::wvRainbow    , 320,  40},
    {  48, Engine::wvRainbow    , 320, 160},
    {  50, Engine::wvRainbow    , 320, 120},
    
    {  54, Engine::wvCave       , 320, 120},
    {  55, Engine::wvCave       , 320,  90},
    {  56, Engine::wvCave       , 320,  60},
    {  57, Engine::wvCave       , 320,  90},
    {  58, Engine::wvCave       , 320, 120},
    {  59, Engine::wvCave       , 320, 150},
    {  60, Engine::wvCave       , 320, 180},
    {  61, Engine::wvCave       , 320, 150},
    
    {  64, Engine::wvRotating   , 320, 120},
    {  65, Engine::wvRainbow    , 320,  40},
    {  66, Engine::wvRainbow    , 320, 160},
    {  67, Engine::wvRainbow    , 320, 120},
    {  68, Engine::wvRotating   , 320, 120},
    {  69, Engine::wvCyan       , 320, 160},
    {  71, Engine::wvGreen      , 320,  80},    
    {  72, Engine::wvBlue       , 320, 160},
        
    {  74, Engine::wvMoveCave   , 320, 120},
    {  76, Engine::wvMoveCave   , 320,  60},
    {  78, Engine::wvMoveCave   , 320, 120},
    {  80, Engine::wvMoveCave   , 320, 180},
    {  82, Engine::wvMoveCave   , 320, 150},

    {  85, Engine::wvCube       , 320,  40},
    {  86, Engine::wvCube       , 320, 160},
    {  88, Engine::wvBig        , 320, 120},
    {  90, Engine::wvCube       , 320, 160},
    {  92, Engine::wvBig        , 320,  80},
    {  94, Engine::wvRotating   , 320, 120},
    {  96, Engine::wvBig        , 320,  80},
    
    { 100, Engine::wvShutCave   , 320, 120},
    { 102, Engine::wvShutCave   , 320,  60},
    { 104, Engine::wvShutCave   , 320, 120},
    { 106, Engine::wvShutCave   , 320,  60},
    { 108, Engine::wvShutCave   , 320, 120},
    { 110, Engine::wvShutCave   , 320, 180},
    
    { 112, Engine::wvCube       , 320,  40},
    { 112, Engine::wvCube       , 320, 160},
    
    { 115, Engine::wvBoss       , 320,  80},    
    {9999,    0,    0,    0}
};

void Engine::checkEvents()
{
    int eventTime = position / 80;
    while (eventTime >= level[levelOfst].time && level[levelOfst].time != 9999)
    {
        // add this enemy
        int x = level[levelOfst].x;
        int y = level[levelOfst].y;
        switch (level[levelOfst].wave)
        {
            case wvGreen:
            objects.add (new Monster (Monster::pgreen, Monster::mvSin,    60,   30,  0,   x,    y));
            objects.add (new Monster (Monster::pgreen, Monster::mvSin,    60,   30, 10,   x + 40,    y));
            objects.add (new Monster (Monster::pgreen, Monster::mvSin,    60,   30, 20,   x + 80,    y));
            objects.add (new Monster (Monster::pgreen, Monster::mvSin,    60,   30, 30,   x + 120,    y));
            objects.add (new Monster (Monster::pgreen, Monster::mvSin,    60,   30, 40,   x + 160,    y));
            objects.add (new Monster (Monster::pgreen, Monster::mvSin,    60,   30, 50,   x + 200,    y));            
            break;
            
            case wvBlue:
            objects.add (new Monster (Monster::pblue, Monster::mvSin,    60,   30,  0,   x,    y));
            objects.add (new Monster (Monster::pblue, Monster::mvSin,    60,   30, 10,   x + 40,    y));
            objects.add (new Monster (Monster::pblue, Monster::mvSin,    60,   30, 20,   x + 80,    y));
            objects.add (new Monster (Monster::pblue, Monster::mvSin,    60,   30, 30,   x + 120,   y));
            objects.add (new Monster (Monster::pblue, Monster::mvSin,    60,   30, 40,   x + 160,    y));
            objects.add (new Monster (Monster::pblue, Monster::mvSin,    60,   30, 50,   x + 200,    y));            
            break;
            
            case wvCyan:
            objects.add (new Monster (Monster::plblue, Monster::mvSin,    60,   30,  0,   x,    y));
            objects.add (new Monster (Monster::plblue, Monster::mvSin,    60,   30, 10,   x + 40,    y));
            objects.add (new Monster (Monster::plblue, Monster::mvSin,    60,   30, 20,   x + 80,    y));
            objects.add (new Monster (Monster::plblue, Monster::mvSin,    60,   30, 30,   x + 120,   y));
            objects.add (new Monster (Monster::plblue, Monster::mvSin,    60,   30, 40,   x + 160,    y));
            objects.add (new Monster (Monster::plblue, Monster::mvSin,    60,   30, 50,   x + 200,    y));            
            break;
            
            case wvAsteroid1:
            objects.add (new Monster (Monster::rock2, Monster::mvStop,    0,   0,  0,   x,    y));
            break;
            
            case wvAsteroid2:
            objects.add (new Monster (Monster::rock3, Monster::mvStop,    0,   0,  0,   x,    y));
            break;
            
            case wvCube:
            objects.add (new Monster (Monster::cube, Monster::mvHoriz,    1,   0,  0,   x,    y));
            break;
            
            case wvRainbow:
            objects.add (new Monster (Monster::ppurple,Monster::mvGoCircle, 100,   56,  14,   x + 50,    y));
            objects.add (new Monster (Monster::pblue,  Monster::mvGoCircle, 100,   56,  18,   x + 50,    y));
            objects.add (new Monster (Monster::plblue, Monster::mvGoCircle, 100,   56,  22,   x + 50,    y));
            objects.add (new Monster (Monster::pgreen, Monster::mvGoCircle, 100,   56,  26,   x + 50,    y));
            objects.add (new Monster (Monster::pyellow,Monster::mvGoCircle, 100,   56,  30,   x + 50,    y));
            objects.add (new Monster (Monster::pred,   Monster::mvGoCircle, 100,   56,  34,   x + 50,    y));
            objects.add (new Monster (Monster::ppink,  Monster::mvGoCircle, 100,   56,  38,   x + 50,    y));            
            break;
            
            case wvCave:
            objects.add (new Monster (Monster::rock1, Monster::mvStop,    0,   0,  0,   x,    y -230));
            objects.add (new Monster (Monster::rock1, Monster::mvStop,    0,   0,  0,   x,    y + 30));
            break;
            
            case wvRotating:
            objects.add (new Monster (Monster::cube, Monster::mvGoCircle,  80,   45,   0,   x + 40,    y));
            objects.add (new Monster (Monster::cube, Monster::mvGoCircle,  80,   45,  15,   x + 40,    y));
            objects.add (new Monster (Monster::cube, Monster::mvGoCircle,  80,   45,  30,   x + 40,    y));
            break;
            
            case wvBig:
            objects.add (new Monster (Monster::bigpyramid, Monster::mvHoriz,  0.5, 0, 0,   x,    y));
            break;
            
            case wvMoveCave:
            objects.add (new Monster (Monster::rock1, Monster::mvSin,  100,   40,   0,   x,    y -240));
            objects.add (new Monster (Monster::rock1, Monster::mvSin,  100,   40,   0,   x,    y + 40));
            break;
            
            case wvShutCave:
            objects.add (new Monster (Monster::rock1, Monster::mvSin,  100,  20,  0,   x,    y -220));
            objects.add (new Monster (Monster::rock1, Monster::mvSin,  100,  20, 50,   x,    y + 20));
            break;
            
            case wvWaitCave:
            objects.add (new Monster (Monster::rock1, Monster::mvSin,  100,  15,  0,   x,    y -215));
            objects.add (new Monster (Monster::rock1, Monster::mvSin,  100,  15, 50,   x,    y + 15));
            break;
            
            case wvWeirdCave:
            objects.add (new Monster (Monster::rock1, Monster::mvSin,  100,  15,  0,   x,    y -215));
            objects.add (new Monster (Monster::rock1, Monster::mvSin,  100,  15, 50,   x,    y + 15));
            break;
            
            case wvBoss :
            objects.add (new Monster (Monster::bigcube, Monster::mvHoldCircle,  100, 30, 50,   x - 100,    y));
            parent->playMusic ("MBOSS");
            break;
        }
        levelOfst++;        
    }
}

Engine::Engine (Main *p) : objects (this)
{
    parent = p;
    player = NULL;
    debug = false;
}

void Engine::doneLevel()
{
    objects.killAll();
}

void Engine::die()
{
    lives--;
    if (lives == 0)
    {
        state = 5;
    }
    else
    {
        outroTimer = 20;
        state = 6; // re-init level
    }
}

void Engine::exit()
{
    // go on to next level
    currentLevel++;
    if (currentLevel == 2)
    {
        state = 2;        
    }
    else
    {
        outroTimer = 20;
        state = 6; // re-init level
    }    
}


void Engine::init()
{
    Player::init(parent->getResources());    
    Bullet::init(parent->getResources());    
    Explosion::init(parent->getResources());    
    Bonus::init(parent->getResources());    
    Monster::init(parent->getResources());    
    bg.init(parent->getResources());
    
    srand(time(0));
}

void Engine::initGame ()
{
    // initialize game and player stats.
    // to start a new game.
    state = 0;
    introTimer = 20;
    currentLevel = 0;
    lives = 3;
    score = 0;
    bonusCount = 0;
    initLevel();
}

void Engine::initLevel()
{
    parent->playMusic ("MGAME");
    // initialize objects
    //vector <ObjectInfo>::iterator i;
    player = new Player();
    objects.add (player);
    player->setLocation (60, 100);
    bg.reset();
    position = 0;
    levelOfst = 0;
    level = level1;
}

// resume after die, don't go to start of level
void Engine::resumeLevel()
{
    parent->playMusic ("MGAME");
    // initialize objects
    //vector <ObjectInfo>::iterator i;
    player = new Player();
    objects.add (player);
    player->setLocation (60, 100);
    
    levelOfst -= 3;
    if (levelOfst < 0) levelOfst = 0;
    position = level[levelOfst].time * 80;
    
}

void Engine::resume ()
{
    state = oldState;
    parent->playMusic ("MGAME");
}

// called when boss is defeated
void Engine::nextLevel()
{
    position = 0; 
    levelOfst = 0; 
    parent->playMusic("MGAME");
}

void Engine::draw (BITMAP *buffer)
{
    if (state == 1 || state == 6)
    {
        bg.draw(buffer);        
        objects.draw(buffer);        
               
        textprintf (buffer, font, 0, 0,
            WHITE, "LIFE %02i", lives);
        
        textprintf (buffer, font, 100, 0,
            WHITE, "POWER %02i", bonusCount % 6);
        
        textprintf_right (buffer, font, buffer->w, 0,
            WHITE, "SCORE %06i000", score);
        
        if (isDebug()) textprintf (buffer, font, 0, 0,
            GREEN, "objects %i", objects.size());
        
    } else if (state == 2 || state == 5) {
        clear_to_color (buffer, BLACK);
        
        textprintf_centre (buffer, font, buffer->w / 2, 
            buffer->h / 2, WHITE, 
            (state == 2) 
                ? "Congratulations, you won!"
                : "GAME OVER");
       
        textprintf_centre (buffer, font, buffer->w / 2, 
            buffer->h * 3 / 4, GREY, "Press ENTER");            
    } else if (state == 0) {
        clear_to_color (buffer, BLACK);
        
        if ((introTimer / 3) & 1)
        {
            textprintf_centre (buffer, font, buffer->w / 2, 
                (buffer->h - text_height (font)) / 2, WHITE, 
                "START");
        }
    }
}

void Engine::update ()
{
    int c = 0;
    if (keypressed())
    {    
        c = readkey();
        if (c >> 8 == KEY_ESC)
        {
            oldState = state;
            state = 3;
        }
        //~ if (c >> 8 == KEY_F11)
        //~ {
            //~ debug = !debug;
        //~ }        
    }
    switch (state)
    {
        case 0: // level intro screen showing
            introTimer--;
            if (introTimer == 0)
            {
                state = 1;
                introTimer = 20;
            }
            break;
        case 6:
            outroTimer--;
            if (outroTimer == 0)
            {
                doneLevel();
                resumeLevel();
                state = 0;
                break;
            }
            //break; // go through!
        case 1: // game playing
            // add objects based on position
        
            objects.update();
            bg.update();
            checkEvents();
            position++;
            break;
        case 2: // "start" before level
            if (c >> 8 == KEY_ENTER) { doneLevel(); state = 4; }
            break;
        case 3: // do nothing, main will switch to resume menu.
            break;
        case 4: // do nothing, game is finished (won or lost)
            break;
        case 5: // game over screen showing
            if (c >> 8 == KEY_ENTER) { doneLevel(); state = 4; }
            break;                   
        default:
            assert (false); // shouldn't occur
    }  
}
