#ifndef MAIN_H
#define MAIN_H

#include <allegro.h>
#include "resources.h"
#include "engine.h"
#include "menu.h"

class Main
{
private:
    BITMAP *buffer;
    Resources resources;
    Menu menu;
    Engine engine;
    
    int frame_count;
    int frame_counter;
    int last_fps;
    int update_counter;
    
    // game options
    bool soundOn;
    bool stereo;
    bool hifi;
    bool music;
    bool fpsOn;
    bool windowed;
    bool doublesize;
    
    //state machine
    int state; 
    // start menu, resume menu, playing, quitting
    
    void draw ();
    void update ();
    
    ALSPC_PLAYER *alspc_player;
       
public:
    static volatile int counter;
    int getCounter () { return counter; }
    Resources* getResources () { return &resources; }
    void playMusic (const char *id);
    void playSample (SAMPLE *s);
    Main ();
    int init(int argc, const char *const *argv);
    void run();
    void done();
    ~Main();
    
    bool isSoundOn() { return soundOn; }
    void setSoundOn(bool value); 
    bool isMusicOn() { return music; }
    void setMusicOn(bool value); 
    bool isStereoOn() { return stereo; }
    void setStereoOn(bool value); 
    bool isHifiOn() { return hifi; }
    void setHifiOn(bool value); 
};

#endif
