#ifndef ANIM_H
#define ANIM_H

#include "resources.h"
#include <stdio.h>
#include <vector>
#include <map>
#include <string>
#include <assert.h>

using namespace std;

class Frame
{
public:
    RLE_SPRITE *rle;
    int time;
};

class Anim
{
private:
    vector<Frame> frames;
public:
    void add (Frame &f);
    RLE_SPRITE *getFrame (int f) 
    {
        assert (f >= 0 && f < getFrameCount());
        return frames[f].rle;
    }
    int getFrameTime (int f)
    {
        assert (f >= 0 && f < getFrameCount());
        return frames[f].time;
    }
    int getFrameCount()
    {
        return frames.size();
    }
    static void loadFromFile (FILE *f, Resources *res, map<string, Anim*> &result);
};

#endif
