#include "resources.h"
#include <stdio.h>
#include <assert.h>
#include "anim.h"

using namespace std;

#ifndef PI
#define PI 3.1415926
#endif

RLE_SPRITE *atom_sprite[3];

struct atom {
	//float y, z, x;
	float x, y, z;
	int bmp;
};

atom h2o[] = {
	{  0.0,   0.0   ,  0.0,    1 },
	{  1.0,   0.0   ,  0.0,    0 },
	{ -0.5, -0.866,  0.0,    0 },
	{  0.0,   0.0   ,  0.0,    -1 }
};

atom o2[] = {
	{ -0.4,   -0.4, 0.0,   1 },
	{  0.4,     0.4, 0.0,   1 },
	{  0.0,     0.0,  0.0,  -1 }
};

atom nh3[] = {
	{  0.0, 0.0,   0.0   , 2 },
	{  0.0, 1.0,   0.0   , 0 },
	{  0.0,-0.5, -0.866,  0 },
	{  0.0,-0.5,  0.866,  0 },
	{  0.0,   0.0   ,  0.0,    -1 }
};


atom ch4[] = {
  { 0.0000000 ,    0.0000000 ,    0.0000000 , 3},
  { 0.6375302 ,    0.6375302 ,    0.6375302 , 0},
  { 0.6375302 ,   -0.6375302 ,   -0.6375302 , 0},
  { -0.6375302 ,    0.6375302 ,   -0.6375302 , 0},
  {  -0.6375302 ,   -0.6375302 ,    0.6375302 , 0},
	{  0.0,   0.0   ,  0.0,    -1 }
};

void Resources::draw_atom (BITMAP *buffer, atom *a, float xrot, float yrot, float zrot, int bondlen)
{
    clear_to_color (buffer, makecol (255, 0, 255));
    
    // first copy the struct to a new struct
    atom myat[10];
    int count = 0, i, j;
    MATRIX_f m;
    
    memcpy (myat, a, sizeof (myat));
    
    // determine # of atoms
    while (myat[count].bmp != -1) count++;
    
    // rotate
    get_rotation_matrix_f (&m, xrot, yrot, zrot);
    
    for (i = 0; i < count; ++i)
    {
        apply_matrix_f (&m, 
            myat[i].x, myat[i].y, myat[i].z, 
            &myat[i].x, &myat[i].y, &myat[i].z );
    }	
    // sort
    for (i = 0; i < count; ++i)
            for (j =0; j < i; ++j)		
                    if (myat[j].z > myat[i].z)
                    {
                            atom temp;
                            memcpy (&temp, &myat[i], sizeof (atom));
                            memcpy (&myat[i], &myat[j], sizeof (atom));
                            memcpy (&myat[j], &temp, sizeof (atom));
                    }
            
    
    // draw
    for (i = 0; i < count; ++i)
    {
            draw_rle_sprite (buffer, atom_sprite[myat[i].bmp], 		    
                (buffer->w - atom_sprite[myat[i].bmp]->w)/ 2 + (int)(myat[i].x * bondlen), 
                (buffer->h - atom_sprite[myat[i].bmp]->h)/ 2 + (int)(myat[i].y * bondlen)
            );
    }
}

void Resources::makeHitAnim (char *id, char *id2)
{
    RLE_SPRITE * s = getRle (id);    
    BITMAP *temp = create_bitmap (s->w, s->h);
    clear_to_color (temp, makecol (255, 0, 255));
    draw_rle_sprite (temp, s, 0, 0);
    int x, y;
    for (x = 0; x < s->w; ++x)
        for (y = 0; y < s->h; ++y)
            if (getpixel (temp, x, y) != makecol (255, 0, 255)) 
                putpixel (temp, x, y, makecol (255, 255, 255));
    RLE_SPRITE *temp_rle = get_rle_sprite (temp);
    destroy_bitmap (temp);
    generated.push_back (temp_rle);
    Frame f;
    f.rle = temp_rle;
    f.time = 0;
    Anim *a = new Anim();
    a->add (f);
    animlist.insert (pair<string, Anim*>(id2, a));    
}

Resources::Resources()
{
    data = NULL;
}

void Resources::makeMolecules()
{
    BITMAP *temp = create_bitmap (16, 16);    
    RLE_SPRITE *temp_rle;
    Anim *a[3];
    Frame f;    
    int i;
    
    atom_sprite[0] = getRle ("H");
    atom_sprite[1] = getRle ("O");
    atom_sprite[2] = getRle ("N");
    atom_sprite[3] = getRle ("C");
    
    for (i = 0; i < 4; i++) a[i] = new Anim();

    for (i = 0; i < 64; ++i)
    {
        
        draw_atom (temp, nh3, 32, i * 4, 32, 5);
        temp_rle = get_rle_sprite (temp);
        generated.push_back (temp_rle);
        f.rle = temp_rle;
        f.time = 10;        
        a[0]->add (f);
    
        draw_atom (temp, o2, 0, 0, i * 4, 6);
        temp_rle = get_rle_sprite (temp);
        generated.push_back (temp_rle);
        f.rle = temp_rle;
        f.time = 10;        
        a[1]->add (f);

        draw_atom (temp, h2o, 0, 0, i * 4, 5);
        temp_rle = get_rle_sprite (temp);
        generated.push_back (temp_rle);
        f.rle = temp_rle;
        f.time = 10;        
        a[2]->add (f);

        draw_atom (temp, ch4, 0, 0, i * 4, 6);
        temp_rle = get_rle_sprite (temp);
        generated.push_back (temp_rle);
        f.rle = temp_rle;
        f.time = 10;        
        a[3]->add (f);        
            
    }    
    animlist.insert (pair<string, Anim*>("NH3_2", a[0]));
    animlist.insert (pair<string, Anim*>("O2_2", a[1]));
    animlist.insert (pair<string, Anim*>("H2O_2", a[2]));
    animlist.insert (pair<string, Anim*>("CH4_2", a[3]));    
}

int Resources::init()
// returns 1 on succes, 0 on failure
{
    // load dat file
    if (!(data = load_datafile ("mars.dat")))
    {
        return 0;
    }    
    
    // load anims
    FILE *f;
    
    f = fopen ("data/anim.txt", "rt");
    Anim::loadFromFile (f, this, animlist);
    fclose (f);
    
    makeMolecules();
    makeHitAnim ("PBLUE", "HPBLUE");
    makeHitAnim ("PLBLUE", "HPLBLUE");
    makeHitAnim ("PGREEN", "HPGREEN");
    makeHitAnim ("PPINK", "HPPINK");
    makeHitAnim ("PPURPLE", "HPPURPLE");
    makeHitAnim ("PBIG", "HPBIG");
    makeHitAnim ("PRED", "HPRED");
    makeHitAnim ("PYEL", "HPYEL");
    makeHitAnim ("CUBE", "HCUBE");
    makeHitAnim ("CUBEBIG", "HCUBEBIG");
    return 1;
}

Resources::~Resources()
{
    {
        map<string, Anim*>::iterator i;
        for (i = animlist.begin(); i != animlist.end(); i++)
        {
            delete (i->second);
        }
    }    
}

FONT *Resources::getFont (const char *id)
{
    DATAFILE *temp;
    assert (data);
    temp = find_datafile_object (data, id);
    assert (temp && temp->type == DAT_FONT);
    return (FONT*)temp->dat;    
}

RLE_SPRITE *Resources::getRle (const char *id)
{
    DATAFILE *temp;
    assert (data);
    temp = find_datafile_object (data, id);
    assert (temp && temp->type == DAT_RLE_SPRITE);
    return (RLE_SPRITE*)temp->dat;    
}

SAMPLE *Resources::getSample (const char *id)
{
    DATAFILE *temp;
    assert (data);
    temp = find_datafile_object (data, id);
    assert (temp && temp->type == DAT_SAMPLE);
    return (SAMPLE*)temp->dat;    
}

ALSPC_DATA *Resources::getSPC (const char *id)
{
    DATAFILE *temp;
    assert (data);
    temp = find_datafile_object (data, id);
    assert (temp && temp->type == DAT_ALSPC);
    return (ALSPC_DATA*)temp->dat;    
}

Anim *Resources::getAnim (const char *id)
{
    assert (animlist.find (id) != animlist.end());
    return animlist[id];
}
