#include "object.h"
#include "engine.h"
#include "main.h"
#include "anim.h"
#include "player.h"
#include "monster.h"
#include "misc.h"

Object *ObjectFactory::create (ObjectInfo &info)
{
    Object *temp;
    switch (info.type)
    {
        case OBJECTTYPE_PLAYERSTART:
            temp = new Player();
            break;
        default : assert (false);
    }
    temp->setLocation (info.x, info.y);
    return temp;
}

void Object::setAnim (Anim *a)
{
    current = a;
    frame = 0;
    animcounter = 0;
}

Resources *Object::getResources()
{
    if (parent)
        return parent->getParent()->getParent()->getResources();
    else
        return NULL;
    
}

Object::Object ()
{
    current = NULL;
    frame = 0;
    animcounter = 0;
    x = 0;
    y = 0;
    w = 8;
    h = 8;
    sprdx = 0;
    sprdy = 0;
    visible = false;
    alive = true;
    solid = false;
    parent = NULL;
}

void Object::setParent (Objects *p)
{
    parent = p;
}

RLE_SPRITE *Object::getSprite ()
{
    if (!current) return NULL;
    return current->getFrame (frame);
}

void Object::try_move (fix dx, fix dy)
{
    int dxleft = dx, dyleft= dy;
    int ddx = dx > 0 ? 1 : -1;
    int ddy = dy > 0 ? 1 : -1;    
    int trydx, trydy;
    bool valid = true;
    while ((abs(dxleft) > 0 || abs (dyleft) > 0) && valid)
    {
        if (abs(dxleft) > abs(dyleft))
        {
            trydy = 0;
            if (abs(dxleft) >= 1)
                trydx = ddx;
            else
                trydx = dxleft;
        }
        else
        {
            trydx = 0;
            if (abs(dyleft) >= 1)
                trydy = ddy;
            else
                trydy = dyleft;
        }
        // check if (x +  |trydx, y + trydy) is valid
        
        // ....
        
        
        if (valid)
        {
            x += trydx;
            dxleft -= trydx;
            y += trydy;
            dyleft -= trydy;
        }        
    }
}
   
void Object::setLocation (fix nx, fix ny)
{
    x = nx;
    y = ny;
}

void Objects::killAll()
{
    list<Object*>::iterator i;
    for (i = objects.begin(); i != objects.end(); ++i)
    {
        delete (*i);
        (*i) = NULL;
    }
    objects.clear();    
}

void Object::update()
{
    assert (parent);
    if (!current) return;
    
    // ask current time
    int counter = parent->getParent()->getParent()->getCounter();
    
    // if we're lagging behind too much, catch up at once
    if (counter - animcounter > 1000) animcounter = counter;
    
    // if frametime is 0, loop same frame forever
    if (current->getFrameTime (frame) > 0) 
    // otherwise, see if we need to go to the next frame.
    {
        while (counter - animcounter > current->getFrameTime (frame))
        {
            animcounter += current->getFrameTime (frame);
            frame++;
            //allegro_message ("%i, %i", frame, current->getFrameCount());
            if (frame >= current->getFrameCount()) frame = 0;
        }
    }    
    w = current->getFrame(frame)->w;
    h = current->getFrame(frame)->h;
}


void Objects::add(Object *o)
{
    objects.push_back (o);
    o->setParent (this);
}

class MyObjectRemover
{
   public:
      bool operator()(Object *o)
      {
         if (!o->isAlive())
         {
            delete o;
            return 1;
         }
         return 0;
      }
};

void Objects::update()
{
    list<Object*>::iterator i;
    for (i = objects.begin(); i != objects.end(); i++)
    {
        if ((*i)->isAlive()) (*i)->update();
    }
    
    // collission detection!    
    list<Object*>::iterator j;
    for (i = objects.begin(); i != objects.end(); i++)
        for (j = objects.begin(); j != i; j++)
    {
        // see if bb interesect
        if ((*i)->isAlive() && (*j)->isAlive())
        {
            int x1 = (*i)->getx();
            int y1 = (*i)->gety();
            int w1 = (*i)->getw();
            int h1 = (*i)->geth();
            int x2 = (*j)->getx();
            int y2 = (*j)->gety();
            int w2 = (*j)->getw();
            int h2 = (*j)->geth();
            if(!((x1 >= x2+w2) || (x2 >= x1+w1) || (y1 >= y2+h2) || (y2 >= y1+h1)))
            {
                (*i)->handleCollission ((*j));
                (*j)->handleCollission ((*i));
            }
        }        
    }
    
    // remove all that are not alive!
    objects.remove_if (MyObjectRemover());
}

void Objects::draw (BITMAP *buffer)
{
    list<Object*>::iterator i;
    for (i = objects.begin(); i != objects.end(); i++)
    {
        if ((*i)->isVisible() && (*i)->isAlive())
        {
            RLE_SPRITE *rle = (*i)->getSprite();
            if (rle)
            {
                draw_rle_sprite (buffer, (*i)->getSprite(), 
                    (*i)->getSprx(), (*i)->getSpry());
            }
            if (parent->isDebug())
            {
                rect (buffer, 
                    (*i)->getx(), 
                    (*i)->gety(),
                    (*i)->getx() + (*i)->getw(), 
                    (*i)->gety() + (*i)->geth(),
                    GREEN);
            }            
        }
    }
}

