#include "bg.h"

using namespace std;

void Bg::init(Resources *res)
{   
    sprite = res->getRle ("HILLS");
    reset();    
    horizon = 170;
    background = create_bitmap (320, horizon - 1);
    clear_bitmap (background);
    int i;
    for (i = 0; i < 500; ++i)
    {
        int x = rand() % background->w;
        int y = rand() % background->h;
        int color = rand() % 255;
        putpixel (background, x, y, makecol (color, color, color));
        putpixel (background, x + 1, y, makecol (color / 2, color / 2, color / 2));
        putpixel (background, x, y + 1, makecol (color / 2, color / 2, color / 2));
        putpixel (background, x - 1, y, makecol (color / 2, color / 2, color / 2));
        putpixel (background, x, y - 1, makecol (color / 2, color / 2, color / 2));
    }
    floor = create_bitmap (32, 32);
    clear_to_color (floor, makecol (154, 77, 14));
    for (i = 0; i < 40; ++i)
    {
        int x = rand() % floor->w;
        int y = rand() % floor->h;
        putpixel (floor, x, y, makecol (200, 100, 20));        
    }
}

void Bg::update()
{
    static int skip = 0;
    if (skip == 0)
    {
        x ++;
        x %= sprite->w;
        skip = 1;
    }
    else
    {
        skip--;
    }
    x2 += itofix (1);
}

/* MODE_7_PARAMS is a struct that contains all different parameters
that are relevant for mode 7, so you can pass them to the functions
as a whole*/
typedef struct MODE_7_PARAMS
{
    fixed space_z; // this is the height of the camera above the plane.
    int horizon; // this is the number of pixels line 0 is below the horizon.
    fixed scale_x, scale_y; // this determines the scale of space coordinates
    // to screen coordinates
} MODE_7_PARAMS;

void mode_7 (int ystart, BITMAP *bmp, BITMAP *tile, fixed angle, fixed cx, fixed cy, MODE_7_PARAMS params)
{
    // current screen position
    int screen_x, screen_y;

    //the distance and horizontal scale of the line we are drawing
    fixed distance, horizontal_scale;

    // masks to make sure we don't read pixels outside the tile
    int mask_x = (tile->w - 1);
    int mask_y = (tile->h -1);

    // step for points in space between two pixels on a horizontal line
    fixed line_dx, line_dy;

    // current space position
    fixed space_x, space_y;

    for (screen_y = ystart; screen_y < bmp->h; screen_y++)
    {
        // first calculate the distance of the line we are drawing
        distance = fdiv (fmul (params.space_z, params.scale_y),
            itofix (screen_y + params.horizon));
        // then calculate the horizontal scale, or the distance between
        // space points on this horizontal line
        horizontal_scale = fdiv (distance, params.scale_x);

        // calculate the dx and dy of points in space when we step
        // through all points on this line.
        line_dx = fmul (-fsin(angle), horizontal_scale);
        line_dy = fmul (fcos(angle), horizontal_scale);

        // calculate the starting position
        space_x = cx + fmul (distance, fcos(angle)) - bmp->w/2 * line_dx;
        space_y = cy + fmul (distance, fsin(angle)) - bmp->w/2 * line_dy;

        // go through all points in this screen line
        for (screen_x = 0; screen_x < bmp->w; screen_x++)
        {
            // get a pixel from the tile and put it to screen
            putpixel (bmp, screen_x, screen_y,
                getpixel (tile,
                    fixtoi (space_x) & mask_x,
                    fixtoi (space_y) & mask_y ));
            // go to the next position in space
            space_x += line_dx;
            space_y += line_dy;
        }
    }
}


void Bg::draw(BITMAP *buffer)
{
    //rectfill (buffer, 0, 0, buffer->w, horizon - 1, 0);
    blit (background, buffer, 0, 0, 0, 0, background->w, background->h);
    rectfill (buffer, 0, horizon, buffer->w, buffer->h, makecol (154, 77, 14));
    draw_rle_sprite (buffer, sprite, -x, horizon - sprite->h);
    draw_rle_sprite (buffer, sprite, sprite->w - x, horizon - sprite->h);
    
    static MODE_7_PARAMS params =
    {
        itofix(50), -150, ftofix (1000.0), ftofix (200.0)
    };

    //~ if (key[KEY_Z])
        //~ params.space_z += itofix(5);
    //~ if (key[KEY_X])
        //~ params.space_z -= itofix(5);
    //~ if (key[KEY_Q])
        //~ params.scale_x = fmul (params.scale_x, ftofix (1.5));
    //~ if (key[KEY_W])
        //~ params.scale_x = fdiv (params.scale_x, ftofix (1.5));
    //~ if (key[KEY_E])
        //~ params.scale_y = fmul (params.scale_y, ftofix (1.5));
    //~ if (key[KEY_R])
        //~ params.scale_y = fdiv (params.scale_y, ftofix (1.5));
    //~ if (key[KEY_H])
        //~ params.horizon++;
    //~ if (key[KEY_J])
        //~ params.horizon--;
    
    mode_7 (horizon, buffer, floor, 0, 0, x2 * 2, params);
}
