#include "anim.h"

void Anim::add (Frame &f)
{
    frames.push_back(f);
}

void Anim::loadFromFile (FILE *f, Resources *res, map<string, Anim*> &result)
{
    Frame frame;
    Anim *temp;
    char buffer[1024], name[1024], id[1024];
    bool emptyline;
       
    while (!feof (f))
    {
        emptyline = false;
        // first line should be name
        fgets (buffer, sizeof(buffer), f);        
        if (sscanf (buffer, "%[^\n]", name) == 1)
        {        
            //now read frames
            temp = new Anim;
            do
            {
                if (fgets (buffer, sizeof(buffer), f) == NULL) emptyline = true;                
                if (strlen(buffer) < 3) emptyline = true;
                if (!emptyline)
                {
                    sscanf (buffer, "%s %d", id, &frame.time);
                    frame.rle = res->getRle (id);
                    temp->frames.push_back(frame);
                }            
            }        
            while (!emptyline);
            result.insert (pair<string, Anim*>(name, temp));
        }
    }        
}
