#include <allegro.h>
#include <map>
#include <string>
#include <vector>
#include "alspc.h"

#ifndef RESOURCES_H
#define RESOURCES_H

class Anim;
struct atom;
    
class Resources
{
    DATAFILE *data;
    std::map <std::string, Anim*> animlist;
    std::vector <RLE_SPRITE*> generated; // run-time generated RLE's
    void makeMolecules();    
    void makeHitAnim (char *id, char *id2);
    void draw_atom (BITMAP *buffer, atom *a, float xrot, float yrot, float zrot, int bondlen);
public:
    int init(); // loads resources
    Resources();
    ~Resources();
        
    Anim *getAnim (const char *id);
    FONT *getFont (const char *id);
    RLE_SPRITE *getRle (const char *id);
    SAMPLE *getSample (const char *id);  
    ALSPC_DATA *getSPC (const char *id);
};

#endif
