#ifndef OBJECT_H
#define OBJECT_H

#include <allegro.h>
#include <list>

using namespace std;

class Objects;
class Engine;
class Anim;
class Resources;

#define OBJECTTYPE_PLAYERSTART 0

class ObjectInfo
{
public:
    int x, y, type;
};

// in this class,
// current is not guaranteed to be set.
// parent is not guaranteed to be set,
// although it should be when the first update / draw is called.
class Object
{
private:
    int frame;
    int animcounter;    

    fix z;
    int level;
    fix x, y;
protected:
    int sprdx, sprdy;
    int w, h;
    Anim *current;
    bool solid;
    bool alive;
    bool visible;
    void setAnim (Anim *a);
    Resources *getResources();
    Objects* parent;

    void kill () { alive = false; }
public:
    Object ();
    void setParent (Objects *p);
    
    //fixed getShadowX();
    
    //bool isWalking(); // walking or flying?
    bool isSolid() { return solid; } // can collide with other stuff?
    bool isVisible() { return visible; } // to be drawn?
    //bool hasShadow(); // draw a shadow?
    bool isAlive() { return alive; } // if not, scheduled to be killed
    //virtual int getType();
    //virtual int getClass();
    
        
    RLE_SPRITE *getSprite ();
    
    void try_move (fix dx, fix dy);
    virtual void setLocation (fix nx, fix ny);
    int getSprx () { return x + sprdx; }
    int getSpry () { return y + sprdy; }
    fix getx () { return x; }
    fix gety () { return y; }
    int getw () { return w; }
    int geth () { return h; }
    virtual void update();
    int getLevel () { return level; }
    virtual int getType () { return 0; }
    virtual void handleCollission(Object *o) {}
};

class Objects
{
private:
    Engine *parent;
    list <Object*> objects;
public:
    Objects (Engine *p) { parent = p; }
    Engine *getParent() { return parent; }
    void add(Object *o);
    void update();
    void killAll();
    void draw (BITMAP *buffer);
    int size() { return objects.size(); }; // returns # of objects
};

class ObjectFactory
{
public:
    static Object *create (ObjectInfo &info);
};

#endif
