#ifndef MONSTER_H
#define MONSTER_H

#include "object.h"

class Bullet : public Object
{
    static Anim *bullet[5];
    int bulletType;
    int dx, dy;
public:
    Bullet(int _bulletType, int _dx, int _dy);
    enum {HE = 0, O2, H2O, NH3, CH4};
    static void init(Resources *res);
    virtual void update();
    virtual int getType () { return 2; }
    virtual void handleCollission(Object *o);
    int getBulletType() { return bulletType; }
};

class Explosion : public Object
{
    static Anim *explosion;
    int life;
public:
    Explosion();
    static void init(Resources *res);
    virtual void update();
    virtual int getType () { return 3; }
};

class Bonus : public Object
{
    static Anim *bonus;    
public:
    Bonus();
    static void init(Resources *res);
    virtual void update();
    virtual int getType () { return 5; }
    virtual void handleCollission(Object *o);
};

struct MovePattern 
{
    int moveType;
    fix param1;
    fix param2;
    fix param3;
    int time; // # of frames, 0 = infinite
};

class Monster : public Object
{
    static Anim *monster[15];
    static Anim *hit[15];
    static SAMPLE *explode;
    bool wasHit;
    
    int monsterType;
    int moveType;
    int hp; // hitpoints    
    fix basex, basey, period, radius, phase, dx, dy; // base for sin / cos movement    
    
    MovePattern *pattern;
    int currentPattern;
    int patternTime;
    
    int shoottimer;
    int scoreValue;
public:

    // simple constructor
    Monster(int _monsterType, int _moveType, fix param1, fix param2, fix param3, int x, int y);
    // pattern constructor
    //Monster(int _monsterType, MovePattern *pat);

    virtual void setLocation (fix nx, fix ny);    
    enum {cube = 0, pblue, plblue, pred, pyellow, pgrey, ppurple, ppink, pgreen, 
        rock1, rock2, rock3, spark, bigcube, bigpyramid};
    enum {mvStop = 0, mvSin, mvVert, mvHoriz, mvGoCircle, mvHoldCircle, mvDxdy, mvAbsSin};
    static void init(Resources *res);
    virtual void update();
    virtual int getType () { return 4; }
    virtual void handleCollission(Object *o);
};

#endif
