
#ifndef MENU_H
#define MENU_H

#include <allegro.h>

#include "gui.h"

class Main;
class Anim;

class MainMenu : public Gui
{
public:
    enum {BUTTONSTART = 100, BUTTONQUIT, BUTTONOPTIONS, BUTTONHISCORES};
    MainMenu() 
    {
        add( new GuiTextButton ("Start", BUTTONSTART,      120,  40, 80, 32));
        add( new GuiTextButton ("Options", BUTTONOPTIONS,  120,  80, 80, 32));
//        add( new GuiTextButton ("Hiscore", BUTTONHISCORES, 120, 120, 80, 32));
        add( new GuiTextButton ("Quit", BUTTONQUIT,        120, 160, 80, 32));
    }
};

class OptionsMenu : public Gui
{
public:
    bool getSound() { return (bool)getGroupSelection(0); }
    bool getMusic() { return (bool)getGroupSelection(1);}
    bool getStereo() { return (bool)getGroupSelection(2); }
    bool getHifi() { return (bool)getGroupSelection(3); }    
    void setSound(bool value) { setGroupSelection(0, value ? 1 : 0); }
    void setMusic(bool value) { setGroupSelection(1, value ? 1 : 0); }
    void setStereo(bool value) { setGroupSelection(2, value ? 1 : 0); }
    void setHifi(bool value) { setGroupSelection(3, value ? 1 : 0); }    
    enum {BUTTONRETURN = 100, BUTTONOTHER};
    OptionsMenu() 
    {
        add( new GuiTextGroupItem ("Sound on",  0, 1,  20,  20, 80, 24));
        add( new GuiTextGroupItem ("Sound off", 0, 0, 180,  20, 80, 24));
        
        add( new GuiTextGroupItem ("Music on",  1, 1,  20,  50, 80, 24));
        add( new GuiTextGroupItem ("Music off", 1, 0, 180,  50, 80, 24));
        
        add( new GuiTextGroupItem ("Stereo",    2, 1,  20,  80, 80, 24));        
        add( new GuiTextGroupItem ("Mono",      2, 0, 180,  80, 80, 24));
        
        add( new GuiTextGroupItem ("22 kHz",    3, 0,  20, 110, 80, 24));
        add( new GuiTextGroupItem ("44 kHz",    3, 1, 180, 110, 80, 24));
                
        add( new GuiTextButton ("Return", BUTTONRETURN,        120, 200, 80, 32));
        
        setSound (false);
        setMusic (false);
        setStereo (false);
        setHifi (false);
    }
};

class Menu
{
    int state;
    int menuState;
    // -1 = showing, 0 = quit, 1 = start new, 2 = resume
    bool isResume;
    Main *parent;
    
    Anim *mouseAnim;
    int mouseFrame;
    int mouseCounter;
        
    void doMenuItem(int i);
    int cursor;
   
    MainMenu mainMenu;
    OptionsMenu optionsMenu;    
public:
    Menu(Main *p);
    ~Menu(); 
    void draw (BITMAP *buffer);
    void update();
    void init (); 

    void done () {  }
    void initStart();
    void initResume();  
    int getState() { return state; }
};

#endif
