#ifndef ENGINE_H
#define ENGINE_H

#include <allegro.h>
#include "object.h"
#include "bg.h"

class Main;
class Player;

struct LevelEvent
{
    int time;
    int wave;
    int x;
    int y;    
};

class Engine
{
private:
    int state;
    int oldState;

    int introTimer;
    int outroTimer;
    
    // player stats

    int currentLevel;
    LevelEvent *level; // points to first event in level array

    int levelOfst; // points to next event in level array
    
    Main *parent;
       
    int mapcurrentframe;
    int mapframecounter;
    Objects objects;
    Player *player;
    bool debug;
    Bg bg;

    int position; // universal postion counter
    void checkEvents();
    
public:
    Engine (Main *p);
    Main *getParent() { return parent; }
    void initGame ();
    void init(); // call once during startup
    void resume ();
    void draw (BITMAP *buffer);
    void update ();
    int getState () { return state; }
    int getPosition () { return position; }
    void nextLevel();
    void initLevel ();
    void resumeLevel();
    Player *getPlayer () { return player; }
    void doneLevel (); // clean up objects etc.
    bool isDebug () { return debug; }
    
    int bonusCount;
    int lives;
    int score;    
    
    void die(); // called when player dies
    void exit(); // called when player has found exit
    
    enum { wvGreen, wvBlue, wvCyan, wvAsteroid1, wvAsteroid2, wvCube,
        wvRainbow, wvCave, wvRotating, wvBig, wvMoveCave, wvShutCave, 
        wvWaitCave, wvWeirdCave, wvBoss };

};

#endif
