/*
 * ALSPC - SPC playback library for Allegro
 * get the latest version at my website: http://www.student.wau.nl/~martijni/
 *
 * (c) Copyright 2003 Martijn van Iersel (amarillion@yahoo.com) 
 * version 0.91
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef ALSPC_H
#define ALSPC_H

#define ALSPC_BUFFER_MULTIPLIER 20 
// determines size of buffer. size of 20 means update needs to be polled 100/20 = 5 times/sec

#ifndef snes9x_types_defined
#define snes9x_types_defined
typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned int uint32;
typedef unsigned char bool8;
typedef signed char int8;
typedef short int16;
#ifndef _WIN32
typedef int int32;
typedef long long int64;
#else
#ifndef WSAAPI
// winsock2.h typedefs int32 as well.
typedef long int32;
#endif
//typedef __int64 int64; // line replaced by amarillion
typedef long long int64;
#endif
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#if defined(__i386__) || defined(__i486__) || defined(__i586__) || \
    defined(__WIN32) || defined(__alpha__)
#define LSB_FIRST
#define FAST_LSB_WORD_ACCESS
#else
#define MSB_FIRST
#endif

#include <allegro.h>

#define DAT_ALSPC DAT_ID ('A', 'S', 'P', 'C')

typedef union
{
#ifdef LSB_FIRST
    struct { uint8 A, Y; } B;
#else
    struct { uint8 Y, A; } B;
#endif
    uint16 W;
} YAndA;

typedef struct SAPURegisters{
    uint8  P;
    YAndA YA;
    uint8  X;
    uint8  S;
    uint16  PC;
} SAPURegisters;

typedef enum
{
  SPC_EMULATOR_UNKNOWN = 0,
  SPC_EMULATOR_ZSNES,
  SPC_EMULATOR_SNES9X
} SPC_EmulatorType;

typedef struct SPC_ID666
{
  char songname[33];
  char gametitle[33];
  char dumper[17];
  char comments[33];
  char author[33];
  int playtime;
  int fadetime;
  SPC_EmulatorType emulator;
} SPC_ID666;

typedef struct ALSPC_DATA
{
    SAPURegisters BackupAPURegisters;
    unsigned char BackupAPURAM[65536];
    unsigned char BackupAPUExtraRAM[64];
    unsigned char BackupDSPRAM[128];
    SPC_ID666 id;
} ALSPC_DATA;

typedef struct ALSPC_PLAYER
{
    AUDIOSTREAM *stream;
    int sample_count; // == buf_size / bytes_per_sample
    int bytes_per_sample; // == 1 for 8 bit, 2 for 16 bit * # of channels.
    int buf_size;
} ALSPC_PLAYER;

#ifdef __cplusplus
   extern "C" {
#endif
       
ALSPC_DATA *alspc_load (const char *fname);
 

void alspc_install ();
void alspc_uninstall ();

void alspc_unload (ALSPC_DATA *alspc);

ALSPC_PLAYER *alspc_start 
    (ALSPC_DATA *alspc, 
    int sampling_rate, 
    int volume, 
    int pan, 
    int stereo, 
    int is_interpolation);

void alspc_stop (ALSPC_PLAYER *player);
void alspc_poll (ALSPC_PLAYER *alspc);

#ifdef __cplusplus
   }
#endif

#endif
