#include "shandler.h"
#include <assert.h>

void ScoreHandler::activate ()
{
    current_score_player = 0;
}

void ScoreHandler::draw (BITMAP *buffer, BITMAP *title, BITMAP *panel)
{
    assert (hiscore);
    hiscore->draw(buffer, title, panel);
}

void ScoreHandler::update (GameEngine &ge)
{
    assert (hiscore);
    if (current_score_player >= 4) return;

    while (hiscore->finished() && current_score_player < 4)
    {
        if (ge.getPlayerType (current_score_player) == HUMAN)
            hiscore->enter (current_score_player,
                 ge.getPlayerTreasures(current_score_player),
                 ge.getPlayerTime(current_score_player));
        current_score_player++;
    }
    hiscore->update ();
}

bool ScoreHandler::finished ()
{
    return current_score_player == 4;
}
