#include "menu.h"
#include <gstream.h>
#include <gmanip.h>

#define RELX( x ) (( x ) * buffer->w / 640)
#define RELY( x ) (( x ) * buffer->h / 480)

void Menu::setGameEngine (GameEngine *newge)
{
    ge = newge;
}

void Menu::draw (BITMAP *buffer, BITMAP *title, BITMAP *panel)
{
    const char *titlename = "MAGIC MAZE";
    const char *status [] = {
     "Computer player", "Human player", "Not in use" };
    const char *cpcolor [] = {"Red", "Yellow", "Blue", "Purple"};

    gstream gs (title);

    gs << color (1)
       << x((title->w - text_length (font, titlename)) / 2)
       << titlename << flush;

    int i, n;
    gstream gs2 (panel);
    gs2.set_wrap (true);
    gs2 << color (1);
    gs2.set_tab (RELX(32));
    gs2.set_tab (RELX(208));
    for (i = 0; i < 4; i++)
    {
        switch (ge->getPlayerType(i))
        {
        case UNUSED : n = 2; break;
        case COMPUTER : n = 0; break;
        case HUMAN : n = 1; break;
        }
        gs2 << i + 1 << "\t" << cpcolor[i] << "\t: " << status[n] << "\n\n";
    }

    gs2 << "\n" << color (1)
       << "Press H for help, Enter to start the game, "
       << "V to view the hi-scores, ESC to quit, 1..4 to "
       << "change the status of a player "
       << "+/- to change the board size (currently "
       << ge->getMapSize() << " x " << ge->getMapSize() << ")"
       << flush;
}

void Menu::drawHelp (BITMAP *buffer, BITMAP *title, BITMAP *panel)
{
    gstream gsTitle (title);
    const char *titlename = "HELP";
    gsTitle << color (1)
       << x((title->w - text_length (font, titlename)) / 2)
       << titlename << flush;

    gstream gsPanel (panel);
    gsPanel.set_wrap (true);
    gsPanel.set_line_spacing (RELY(-6));
    gsPanel << color (1)
        << "This game was written for the Allegro Speedhack Competition 2001 "
        << "by Martijn van Iersel & Jules Beulen. "
        << "amarillion@yahoo.com ikkjb@netscape.net\n\n"
        << "The object of this game is to collect the most coins. "
        << "You can only collect the coins of your color. "
        << "The coins are dropped randomly by a donkey. "
        << "Sometimes walls are blocking your way. "
        << "Luckily some walls are moveable.\n\n"
        << "Each turn you can push a piece of wall into the maze, "
        << "Thus moving a whole part of the maze. "
        << "Move & rotate the piece of wall with the arrow keys. "
        << "Push the wall into the maze with ENTER. "
        << "After that you can move your guy with the arrow keys. "
        << "The first one who collects a certain number of treasures, wins.\n\n"
        << "Press a key to return to the main menu." << flush;
}

void Menu::init()
{
    menu_finished = FALSE;
    menu_choice = 0;
}

int Menu::getChoice()
{
    return menu_choice;
}

bool Menu::finished()
{
    return menu_finished;
}

void Menu::update()
{
    if (keypressed()) switch (readkey() >> 8)
    {
         case KEY_ESC:
             menu_choice = 0;
             menu_finished = true;
             break;
         case KEY_PLUS_PAD:
             if (ge->getMapSize() < 9)
                 ge->setMapSize (ge->getMapSize() + 2);
             break;
         case KEY_MINUS_PAD:
             if (ge->getMapSize() > 5)
                 ge->setMapSize (ge->getMapSize() - 2);
             break;
         case KEY_ENTER:
             menu_choice = 2;
             menu_finished = true;
             break;
         case KEY_V:
             menu_choice = 4;
             menu_finished = true;
             break;
         case KEY_H:
             menu_choice = 1;
             menu_finished = true;
             break;
         case KEY_1:
             ge->setPlayerType (0, (ge->getPlayerType (0) + 1) % 3);
             break;
         case KEY_2:
             ge->setPlayerType (1, (ge->getPlayerType (1) + 1) % 3);
             break;
         case KEY_3:
             ge->setPlayerType (2, (ge->getPlayerType (2) + 1) % 3);
             break;
         case KEY_4:
             ge->setPlayerType (3, (ge->getPlayerType (3) + 1) % 3);
             break;
    }
}
