#include "mengine.h"
#include "JBdraw.h"
#include "menu.h"

#define RELX( x ) (( x ) * background->w / 640)
#define RELY( x ) (( x ) * background->h / 480)

void MainEngine::createbackground()
{
    srand (0);
    rectfill(background, 0, 0, background->w , background->h , 9);
    int i, n;
    for (i = 0; i < 9999; i++)
    {
        n = (4+(rand()%5));
	putpixel(background,
	    rand() % background->w,
	    rand() % background->h, n);
    }
    
    text_mode(-1);

    // box and arrows at top
    drawarrowleft (background,
        RELX (200),
        RELY (32), 6);
    drawarrowright (background,
        RELX(440),
        RELY (32), 6);
    drawbox (background,
        RELX(220),
        RELX(420),
        RELY(36),
        RELY(8), 7);
    drawbox (background,
        RELX(64),
        RELX(640-64),
        RELY(480-64),
        RELY(480-128), 7);
}

int MainEngine::activate ()
{
    main_loop = true;
    sequence = 0;
    background = create_bitmap (SCREEN_W, SCREEN_H);
    clear_bitmap (background);
    createbackground();

    ge.setPlayerType (0, HUMAN);
    ge.setPlayerType (1, COMPUTER);
    ge.setPlayerType (2, UNUSED);
    ge.setPlayerType (3, UNUSED);
    ge.setMapSize (7);
    ge.setTreasureLimit (10);

    menu.init();
    menu.setGameEngine (&ge);

    data = load_datafile ("maze.dat");
    if (!data)
    {
        allegro_message ("could not open datafile");
        return 0;
    }
    font6 = reinterpret_cast<FONT*>
        (find_datafile_object(data, "SMALL6")->dat);
    font12 = reinterpret_cast<FONT*>
        (find_datafile_object(data, "COMICSS12")->dat);
    if (!font6 || !font12)
    {
        allegro_message ("Data file corrupted, could not find font");
        return 0;
    }
    if (SCREEN_W >= 640)
        font = font12;
    else
        font = font6;
    if (!ge.init (data))
    {
        return 0;
    }
    hiscore.activate ();
    hiscore.load();
    hiscore.sort ();
    score.activate ();
    score.setHiScore (&hiscore);

#ifndef NO_SOUND
    reserve_voices (16, -1);
    if (install_sound (DIGI_AUTODETECT, MIDI_NONE, NULL) < 0)
    {
        allegro_message ("Error initializing sound card\n%s\n", allegro_error);
        return 0;
    }
    if (install_mod (8) < 0)    // leave some for sfx. 8 voices for mod. And
    {                       // 8 for wavs. Get it ?
        allegro_message ("Error setting digi voices");
        return 0;
    }
    ex = load_mod ("maze.dat#MUSIC");
    if (ex==NULL)
    {
        allegro_message ("Error reading Music from datafile");
        return 0;
    }
    set_mod_volume (150);
    play_mod (ex, TRUE);
#endif

    return 1;
}

void MainEngine::deactivate ()
{
    destroy_bitmap (background);
    ge.exit();
    unload_datafile (data);
}

void MainEngine::draw (BITMAP *buffer)
{
    BITMAP *panel, *title;
    if (sequence != 2)
    {
        panel = create_sub_bitmap (buffer,
            RELX (80), RELY (80), RELX (640 - 160), RELY (480 - 160));
        title = create_sub_bitmap (buffer,
            RELX (220), RELY (22), RELX (640-440), RELY (22));
        blit (background, buffer, 0, 0, 0, 0, background->w, background->h);
    }
    // draw stuff
    switch (sequence)
    {
    case 0 : // menu
        definecolors();
        menu.draw (buffer, title, panel);
    break;
    case 1 : // help
        menu.drawHelp(buffer, title, panel);
    break;
    case 2 : // game
        ge.draw(buffer);
    break;
    case 3 : // enter hiscore
        score.draw (buffer, title, panel);
    break;
    case 4 : // show hiscore
        hiscore.display (buffer, title, panel);
    break;
    }
    if (sequence != 2)
    {
        destroy_bitmap (panel);
        destroy_bitmap (title);
    }
}

void MainEngine::update (int msec)
{
    // update stuff
    switch (sequence)
    {
    case 0 : // menu
        menu.update ();
        if (menu.finished())
        {
            switch (menu.getChoice())
            {
            case 0: // esc
                main_loop = FALSE;
                break;
            case 1:
                sequence = 1;
                break;
            case 2:
                sequence = 2;
                ge.activate(); // make game ready to start again
                break;
            case 4:
                sequence = 4;
                break;
            }
            menu.init();
        }
    break;
    case 1 : // help
        if (keypressed())
        {
            readkey();
            sequence = 0;
        }
    break;
    case 2 : // game
        ge.update(msec);
        if (ge.finished())
        {
            while (keypressed()) readkey ();
            definecolors();
            sequence = 3;
        }
    break;
    case 3 : // enter hiscore
        score.update(ge);
        if (score.finished())
        {
            sequence = 4;
            score.activate();
        }
    break;
    case 4 : // show hiscore
        if (keypressed())
        {
            readkey();
            sequence = 0;
        }
    break;
    }
}

void MainEngine::definecolors()
{
    const int colornum = 11;
    const int colors[colornum][4] = // index, r, g, b
    { { 0, 0, 0, 0}, // black
      { 1, 0, 0, 0}, // black
      { 2,13, 0,38}, // blue
      { 3, 0,26,26}, // turquoise
      { 4,38,13, 0}, // brown
      { 5,38, 26,0}, // caramel
      { 6,38,38,0 }, // brown / green
      { 7,38,51,0 }, // bright green
      { 8,20,38, 0}, // middle green
      { 9,13,38, 0}, // greenest
      {10,63,63,63}}; // white

  RGB color;
  int i;
  for (i = 0; i < colornum; i++)
  {
      color.r = colors[i][1];
      color.g = colors[i][2];
      color.b = colors[i][3];
      set_color (colors[i][0], &color);
  }
}
